/*! \file StringParam.h 
 *  \brief: header file for triavertexinput object
 */


#ifndef _STRINGPARAM_H_
#define _STRINGPARAM_H_

/*Headers:*/
/*{{{*/
#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "./Param.h"
#include "../../include/include.h"
#include "../../shared/shared.h"
/*}}}*/

class StringParam: public Param{

	private: 
		/*just hold 3 values for 3 vertices: */
		int enum_type;
		char* value;

	public:
		/*StringParam constructors, destructors: {{{*/
		StringParam();
		StringParam(int enum_type,char* value);
		~StringParam();
		/*}}}*/
		/*Object virtual functions definitions:{{{ */
		void  Echo();
		void  DeepEcho();
		int   Id(); 
		int   MyRank();
		int   ObjectEnum();
		Object* copy();
		/*}}}*/
		/*Param vritual function definitions: {{{*/
		int   InstanceEnum(){return enum_type;}
		void  GetParameterValue(bool* pbool){_error2_("String param of enum " << enum_type << " (" << EnumToStringx(enum_type) << ") cannot return a bool");}
		void  GetParameterValue(int* pinteger){_error2_("String param of enum " << enum_type << " (" << EnumToStringx(enum_type) << ") cannot return an integer");}
		void  GetParameterValue(int** pintarray,int* pM){_error2_("String param of enum " << enum_type << " (" << EnumToStringx(enum_type) << ") cannot return an array of integers");}
		void  GetParameterValue(int** pintarray,int* pM,int* pN){_error2_("String param of enum " << enum_type << " (" << EnumToStringx(enum_type) << ") cannot return an array of integers");}
		void  GetParameterValue(IssmDouble* pIssmDouble){_error2_("String param of enum " << enum_type << " (" << EnumToStringx(enum_type) << ") cannot return a IssmDouble");}
		void  GetParameterValue(char** pstring);
		void  GetParameterValue(char*** pstringarray,int* pM){_error2_("String param of enum " << enum_type << " (" << EnumToStringx(enum_type) << ") cannot return a string array");}
		void  GetParameterValue(IssmDouble** pIssmDoublearray,int* pM){_error2_("String param of enum " << enum_type << " (" << EnumToStringx(enum_type) << ") cannot return a IssmDouble array");}
		void  GetParameterValue(IssmDouble** pIssmDoublearray,int* pM, int* pN){_error2_("String param of enum " << enum_type << " (" << EnumToStringx(enum_type) << ") cannot return a IssmDouble array");}
		void  GetParameterValue(IssmDouble*** parray, int* pM,int** pmdims, int** pndims){_error2_("String param of enum " << enum_type << " (" << EnumToStringx(enum_type) << ") cannot return a matrix array");}
		void  GetParameterValue(Vector** pvec){_error2_("String param of enum " << enum_type << " (" << EnumToStringx(enum_type) << ") cannot return a Vec");}
		void  GetParameterValue(Matrix** pmat){_error2_("String param of enum " << enum_type << " (" << EnumToStringx(enum_type) << ") cannot return a Mat");}
		void  GetParameterValue(FILE** pfid){_error2_("Bool param of enum " << enum_type << " (" << EnumToStringx(enum_type) << ") cannot return a FILE");}

		void  SetValue(bool boolean){_error2_("String param of enum " << enum_type << " (" << EnumToStringx(enum_type) << ") cannot hold a boolean");}
		void  SetValue(int integer){_error2_("String param of enum " << enum_type << " (" << EnumToStringx(enum_type) << ") cannot hold an integer");}
		void  SetValue(IssmDouble scalar){_error2_("String param of enum " << enum_type << " (" << EnumToStringx(enum_type) << ") cannot hold a scalar");}
		void  SetValue(char* string);
		void  SetValue(char** stringarray,int M){_error2_("String param of enum " << enum_type << " (" << EnumToStringx(enum_type) << ") cannot hold a string array");}
		void  SetValue(IssmDouble* IssmDoublearray,int M){_error2_("String param of enum " << enum_type << " (" << EnumToStringx(enum_type) << ") cannot hold a IssmDouble array");}
		void  SetValue(IssmDouble* pIssmDoublearray,int M,int N){_error2_("String param of enum " << enum_type << " (" << EnumToStringx(enum_type) << ") cannot hold a IssmDouble array");}
		void  SetValue(int* intarray,int M){_error2_("String param of enum " << enum_type << " (" << EnumToStringx(enum_type) << ") cannot hold a int array");}
		void  SetValue(int* pintarray,int M,int N){_error2_("String param of enum " << enum_type << " (" << EnumToStringx(enum_type) << ") cannot hold a int array");}
		void  SetValue(Vector* vec){_error2_("String param of enum " << enum_type << " (" << EnumToStringx(enum_type) << ") cannot hold a Vec");}
		void  SetValue(Matrix* mat){_error2_("String param of enum " << enum_type << " (" << EnumToStringx(enum_type) << ") cannot hold a Mat");}
		void  SetValue(FILE* fid){_error2_("String param of enum " << enum_type << " (" << EnumToStringx(enum_type) << ") cannot hold a FILE");}
		void  SetValue(IssmDouble** array, int M, int* mdim_array, int* ndim_array){_error2_("String param of enum " << enum_type << " (" << EnumToStringx(enum_type) << ") cannot hold an array of matrices");}
		void  UnitConversion(int direction_enum);

		void GetParameterName(char**pname);

		/*}}}*/
};
#endif  /* _STRINGPARAM_H */
