/*! \file OptionStruct.h 
 *  \brief: header file for optionstruct object
 */

#ifndef _OPTIONSTRUCT_H_
#define _OPTIONSTRUCT_H_

/*Headers:{{{*/
#include "../../include/include.h"
#include "../../shared/Exceptions/exceptions.h"
#include "../../EnumDefinitions/EnumDefinitions.h"

#include "./Option.h"
/*}}}*/

class OptionStruct: public Option {

	public:

		Options** values;

		/*OptionStruct constructors, destructors {{{*/
		OptionStruct();
		~OptionStruct();
		/*}}}*/
		/*Object virtual functions definitions:{{{*/
		void  Echo();
		void  DeepEcho();
		void  DeepEcho(char* indent);
		int   Id(){_error2_("Not implemented yet");};
		int   MyRank(){_error2_("Not implemented yet");};
		int   ObjectEnum(){return OptionStructEnum;};
		Object* copy(){_error2_("Not implemented yet");};
		/*}}}*/

		/*virtual functions: */
		char* Name();
		int   NumEl();
		int   NDims();
		int*  Size();
		void  Get(int* pvalue){_error2_("An OptionStruct object cannot return a int");};
		void  Get(IssmPDouble* pvalue){_error2_("An OptionStruct object cannot return a IssmPDouble");};
		void  Get(bool* pvalue){  _error2_("An OptionStruct object cannot return a bool");};
		void  Get(char** pvalue){ _error2_("An OptionStruct object cannot return a string");};
		void  Get(char*** ppvalue,int *pnumel){ _error2_("An OptionStruct object cannot return a string vec");};
		void  Get(IssmPDouble** pvalue,int *pnumel){ _error2_("An OptionStruct object cannot return a IssmPDouble vec");};
		void  Get(Options** pvalue);
		void  Get(Options*** ppvalue,int *pnumel);

};
#endif  /* _OPTIONSTRUCT_H */

