/*! \file PentaP1Input.h 
 *  \brief: header file for PentaP1Input object
 */


#ifndef _PENTAP1INPUT_H_
#define _PENTAP1INPUT_H_

/*Headers:*/
/*{{{*/
#include "./Input.h"
#include "../Elements/PentaRef.h"
class GaussTria;
/*}}}*/

class PentaP1Input: public Input, public PentaRef{

	public:
		/*just hold 6 values for 6 vertices: */
		int    enum_type;
		IssmPDouble values[6];

		/*PentaP1Input constructors, destructors: {{{*/
		PentaP1Input();
		PentaP1Input(int enum_type,IssmPDouble* values);
		~PentaP1Input();
		/*}}}*/
		/*Object virtual functions definitions:{{{ */
		void  Echo();
		void  DeepEcho();
		int   Id(); 
		int   MyRank();
		int   ObjectEnum();
		Object* copy();
		/*}}}*/
		/*PentaP1Input management: {{{*/
		int   InstanceEnum();
		Input* SpawnTriaInput(int* indices);
		Input* PointwiseDivide(Input* inputB);
		Input* PointwiseMin(Input* inputB);
		Input* PointwiseMax(Input* inputB);
		ElementResult* SpawnResult(int step, IssmPDouble time);
		void AddTimeValues(IssmPDouble* values,int step,IssmPDouble time){_error2_("not supported yet");};
		void Configure(Parameters* parameters);
		/*}}}*/
		/*numerics: {{{*/
		void GetInputValue(bool* pvalue){_error2_("not implemented yet");};
		void GetInputValue(int* pvalue){_error2_("not implemented yet");};
		void GetInputValue(IssmPDouble* pvalue){_error2_("not implemented yet");};
		void GetInputValue(IssmPDouble* pvalue,GaussTria* gauss){_error2_("not implemented yet");};
		void GetInputValue(IssmPDouble* pvalue,GaussTria* gauss,IssmPDouble time){_error2_("not implemented yet");};
		void GetInputValue(IssmPDouble* pvalue,GaussPenta* gauss);
		void GetInputValue(IssmPDouble* pvalue,GaussTria* gauss ,int index){_error2_("not implemented yet");};
		void GetInputValue(IssmPDouble* pvalue,GaussPenta* gauss ,int index){_error2_("not implemented yet");};
		void GetInputDerivativeValue(IssmPDouble* derivativevalues, IssmPDouble* xyz_list, GaussTria* gauss){_error2_("not implemented yet");};
		void GetInputDerivativeValue(IssmPDouble* derivativevalues, IssmPDouble* xyz_list, GaussPenta* gauss);
		void GetInputAverage(IssmPDouble* pvalue);
		void GetVxStrainRate2d(IssmPDouble* epsilonvx,IssmPDouble* xyz_list, GaussTria* gauss){_error2_("not implemented yet");};
		void GetVyStrainRate2d(IssmPDouble* epsilonvy,IssmPDouble* xyz_list, GaussTria* gauss){_error2_("not implemented yet");};
		void GetVxStrainRate3d(IssmPDouble* epsilonvx,IssmPDouble* xyz_list, GaussPenta* gauss);
		void GetVyStrainRate3d(IssmPDouble* epsilonvy,IssmPDouble* xyz_list, GaussPenta* gauss);
		void GetVzStrainRate3d(IssmPDouble* epsilonvz,IssmPDouble* xyz_list, GaussPenta* gauss);
		void GetVxStrainRate3dPattyn(IssmPDouble* epsilonvx,IssmPDouble* xyz_list, GaussPenta* gauss);
		void GetVyStrainRate3dPattyn(IssmPDouble* epsilonvy,IssmPDouble* xyz_list, GaussPenta* gauss);
		void ChangeEnum(int newenumtype);

		void SquareMin(IssmPDouble* psquaremin, bool process_units,Parameters* parameters);
		void ConstrainMin(IssmPDouble minimum);
		void Scale(IssmPDouble scale_factor);
		void ArtificialNoise(IssmPDouble min,IssmPDouble max){_error2_("not implemented yet");};
		void AXPY(Input* xinput,IssmPDouble scalar);
		void Constrain(IssmPDouble cm_min, IssmPDouble cm_max);
		IssmPDouble InfinityNorm(void);
		IssmPDouble Max(void);
		IssmPDouble MaxAbs(void);
		IssmPDouble Min(void);
		IssmPDouble MinAbs(void);
		void Extrude(void);
		void VerticallyIntegrate(Input* thickness_input);
		void GetVectorFromInputs(Vector* vector,int* doflist);
		void GetValuesPtr(IssmPDouble** pvalues,int* pnum_values);
		/*}}}*/

};
#endif  /* _PENTAP1INPUT_H */
