/*!\file OptionDouble.cpp
 * \brief: implementation of the optionsIssmPDouble object
 */

/*Headers:*/
/*{{{*/
#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include <stdio.h>
#include <string.h>
#include "../objects.h"
#include "../../shared/shared.h"
#include "../../io/io.h"
#include "../../Container/Container.h"
#include "../../include/include.h"
/*}}}*/

/*Constructors/destructor/copy*/
/*FUNCTION OptionDouble::OptionDouble(){{{*/
OptionDouble::OptionDouble(){

	values    =NULL;

}
/*}}}*/
/*FUNCTION OptionDouble::~OptionDouble(){{{*/
OptionDouble::~OptionDouble(){

	if (values) xDelete<IssmPDouble>(values);

}
/*}}}*/

/*Other*/
/*FUNCTION OptionDouble::Echo {{{*/
void  OptionDouble::Echo(){

	char  cstr[81];
	bool  flag=true;

	_printf_(flag,"OptionDouble Echo:\n");
	Option::Echo();

	if (values && size) {
		if(numel == 1) _printf_(flag,"        values: %g\n" ,values[0]);
		else {
			StringFromSize(cstr,size,ndims);
			_printf_(flag,"        values: %s %s\n" ,cstr,"IssmPDouble");
		}
	}
	else _printf_(flag,"        values: [empty]\n" );
}
/*}}}*/
/*FUNCTION OptionDouble::DeepEcho() {{{*/
void  OptionDouble::DeepEcho(){

	char  indent[81]="";

	OptionDouble::DeepEcho(indent);

	return;
}
/*}}}*/
/*FUNCTION OptionDouble::DeepEcho(char* indent) {{{*/
void  OptionDouble::DeepEcho(char* indent){

	int   i;
	int*  dims;
	char  indent2[81];
	char  cstr[81];
	bool  flag=true;

	_printf_(flag,"%sOptionDouble DeepEcho:\n",indent);
	Option::DeepEcho(indent);

	xMemCpy<char>(indent2,indent,(strlen(indent)+1));
	strcat(indent2,"  ");

	if (values) {
		dims=xNew<int>(ndims);
		if(numel==1) _printf_(flag,"%s        values: %g\n" ,indent,values[0]);
		else{
			for (i=0; i<numel; i++) {
				RowWiseDimsFromIndex(dims,i,size,ndims);
				StringFromDims(cstr,dims,ndims);
				_printf_(flag,"%s        values%s: %g\n" ,indent,cstr,values[i]);
			}
		}
		xDelete<int>(dims);
	}
	else _printf_(flag,"%s        values: [empty]\n" ,indent);
}
/*}}}*/
/*FUNCTION OptionDouble::Name {{{*/
char* OptionDouble::Name(){

	return(Option::Name());
}
/*}}}*/
/*FUNCTION OptionDouble::NumEl {{{*/
int   OptionDouble::NumEl(){

	return(Option::NumEl());
}
/*}}}*/
/*FUNCTION OptionDouble::NDims {{{*/
int   OptionDouble::NDims(){

	return(Option::NDims());
}
/*}}}*/
/*FUNCTION OptionDouble::Size {{{*/
int*  OptionDouble::Size(){

	return(Option::Size());
}
/*}}}*/
/*FUNCTION OptionDouble::Get(int* pvalue) {{{*/
void OptionDouble::Get(int* pvalue){

	/*We should first check that the size is one*/
	if(this->NumEl()!=1){
		_error2_("option \"" << this->name << "\" has " << this->NumEl() << " elements and cannot return a single int");
	}

	/*Assign output pointer*/
	*pvalue=(int)this->values[0];
}
/*}}}*/
/*FUNCTION OptionDouble::Get(IssmPDouble* pvalue) {{{*/
void OptionDouble::Get(IssmPDouble* pvalue){

	/*We should first check that the size is one*/
	if(this->NumEl()!=1){
		_error2_("option \"" << this->name << "\" has " << this->NumEl() << " elements and cannot return a single IssmPDouble");
	}

	/*Assign output pointer*/
	*pvalue=this->values[0];
}
/*}}}*/
/*FUNCTION OptionDouble::Get(IssmPDouble** pvalue,int* numel) {{{*/
void OptionDouble::Get(IssmPDouble** pvalue,int* numel){

	/*We should first check that the size is at least one*/
	if(this->NumEl()<=0){
		_error2_("option \"" << this->name << "\" is empty and cannot return a IssmPDouble vector");
	}

	/*Copy vector*/
	IssmPDouble* outvalue=xNew<IssmPDouble>(this->NumEl());
	for(int i=0;i<this->NumEl();i++) outvalue[i]=this->values[i];

	/*Assign output pointer*/
	*pvalue=outvalue;
	if(numel) *numel=this->NumEl();
}
/*}}}*/
