/*!\file OptionStruct.cpp
 * \brief: implementation of the optionsstruct object
 */

/*Headers:*/
/*{{{*/
#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include <stdio.h>
#include <string.h>
#include "../objects.h"
#include "../../shared/shared.h"
#include "../../io/io.h"
#include "../../Container/Container.h"
#include "../../include/include.h"
/*}}}*/

/*Constructors/destructor/copy*/
/*FUNCTION OptionStruct::OptionStruct(){{{*/
OptionStruct::OptionStruct(){

	values    =NULL;

}
/*}}}*/
/*FUNCTION OptionStruct::~OptionStruct(){{{*/
OptionStruct::~OptionStruct(){

	int   i;

	if(values){
		for(i=0; i<numel; i++) {
			delete values[i];
			values[i] =NULL;
		}
		xDelete<Options*>(values);
	}

}
/*}}}*/

/*Other*/
/*FUNCTION OptionStruct::Echo {{{*/
void  OptionStruct::Echo(){

	char  cstr[81];
	bool  flag=true;

	_printf_(flag,"OptionStruct Echo:\n");
	Option::Echo();

	if (values && size) {
		StringFromSize(cstr,size,ndims);
		_printf_(flag,"        values: %s %s\n" ,cstr,"struct");
	}
	else _printf_(flag,"        values: [empty]\n" );
}
/*}}}*/
/*FUNCTION OptionStruct::DeepEcho() {{{*/
void  OptionStruct::DeepEcho(){

	char  indent[81]="";

	OptionStruct::DeepEcho(indent);

	return;
}
/*}}}*/
/*FUNCTION OptionStruct::DeepEcho(char* indent) {{{*/
void  OptionStruct::DeepEcho(char* indent){

	int   i,j;
	int*  dims;
	char  indent2[81];
	char  cstr[81];
	bool  flag=true;

	_printf_(flag,"%sOptionStruct DeepEcho:\n",indent);
	Option::DeepEcho(indent);

	xMemCpy<char>(indent2,indent,(strlen(indent)+1));
	strcat(indent2,"  ");

	if (values) {
		dims=xNew<int>(ndims);
		for (i=0; i<numel; i++) {
			ColumnWiseDimsFromIndex(dims,i,size,ndims);
			StringFromDims(cstr,dims,ndims);
			if (values[i]->Size()){
				_printf_(flag,"%s        values: -------- begin %s --------\n" ,indent,cstr);
				for (j=0; j<values[i]->Size(); j++) ((Option *)values[i]->GetObjectByOffset(j))->DeepEcho(indent2);
				_printf_(flag,"%s        values: --------  end  %s --------\n" ,indent,cstr);
			}
			else _printf_(flag,"%s        values: %s [empty]\n" ,indent,cstr);
		}
		xDelete<int>(dims);
	}
	else _printf_(flag,"%s        values: [empty]\n" ,indent);
}
/*}}}*/
/*FUNCTION OptionStruct::Name {{{*/
char* OptionStruct::Name(){

	return(Option::Name());
}
/*}}}*/
/*FUNCTION OptionStruct::NumEl {{{*/
int   OptionStruct::NumEl(){

	return(Option::NumEl());
}
/*}}}*/
/*FUNCTION OptionStruct::NDims {{{*/
int   OptionStruct::NDims(){

	return(Option::NDims());
}
/*}}}*/
/*FUNCTION OptionStruct::Size {{{*/
int*  OptionStruct::Size(){

	return(Option::Size());
}
/*}}}*/
/*FUNCTION OptionStruct::Get(Options** pvalue) {{{*/
void OptionStruct::Get(Options** pvalue){

	/*We should first check that the size is one*/
	if(this->NumEl()!=1){
		_error2_("option \"" << this->name << "\" has " << this->NumEl() << " elements and cannot return a single options dataset");
	}

	/*Assign output pointer*/
	*pvalue=this->values[0];
}
/*}}}*/
/*FUNCTION OptionStruct::Get(Options*** ppvalue,int* numel) {{{*/
void OptionStruct::Get(Options*** ppvalue,int* numel){

	/*We should first check that the size is at least one*/
	if(this->NumEl()<=0){
		_error2_("option \"" << this->name << "\" is empty and cannot return an options dataset vector");
	}

	/*Assign output pointer*/
	*ppvalue=this->values;
	if(numel) *numel=this->NumEl();
}
/*}}}*/
