/*!\file KML_Unknown.cpp
 * \brief: implementation of the kml_unknown object
 */

/*Headers:*/
/*{{{*/
#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include <stdio.h>
#include <string.h>
#include "../objects.h"
#include "../../shared/shared.h"
#include "../../io/io.h"
#include "../../Container/Container.h"
#include "../../include/include.h"
/*}}}*/

/*Constructors/destructor/copy*/
/*FUNCTION KML_Unknown::KML_Unknown(){{{*/
KML_Unknown::KML_Unknown(){

	name      =NULL;
	value     =NULL;

}
/*}}}*/
/*FUNCTION KML_Unknown::~KML_Unknown(){{{*/
KML_Unknown::~KML_Unknown(){

	if (name      ) xfree((void**)&name);
	if (value     ) xfree((void**)&value);

}
/*}}}*/

/*Other*/
/*FUNCTION KML_Unknown::Echo {{{*/
void  KML_Unknown::Echo(){

	bool  flag=true;

	_printf_(flag,"KML_Unknown %s:\n",name);
	KML_Object::Echo();

	if (value     )
		_printf_(flag,"         value: \"%s\"\n"     ,value);
    else
        _printf_(flag,"         value: [none]\n"     );

	return;
}
/*}}}*/
/*FUNCTION KML_Unknown::DeepEcho {{{*/
void  KML_Unknown::DeepEcho(){

	char  indent[81]="";

	KML_Unknown::DeepEcho(indent);

	return;
}
/*}}}*/
/*FUNCTION KML_Unknown::DeepEcho {{{*/
void  KML_Unknown::DeepEcho(const char* indent){

	char*        valuei;
	char*        vtoken;
	char         nl[]={'\n','\0'};
	bool         flag=true;

	_printf_(flag,"%sKML_Unknown %s:\n",indent,name);
	KML_Object::DeepEcho(indent);

	if (value     ) {
		valuei=(char *) xmalloc((strlen(value)+1)*sizeof(char));
		memcpy(valuei,value,(strlen(value)+1)*sizeof(char)); 
        
		vtoken=strtok(valuei,nl);
		_printf_(flag,"%s         value: \"%s"     ,indent,vtoken);
    
		while (vtoken=strtok(NULL,nl))
			_printf_(flag,"\n%s                 %s"     ,indent,vtoken);
		_printf_(flag,"\"\n");

		xfree((void**)&valuei);
	}
    else
        _printf_(flag,"%s         value: [none]\n"     ,indent);

	return;
}
/*}}}*/
/*FUNCTION KML_Unknown::Write {{{*/
void  KML_Unknown::Write(FILE* filout,const char* indent){

	char*        valuei;
	char*        vtoken;
	char         nl[]={'\n','\0'};

	fprintf(filout,"%s<%s",indent,name);
	WriteAttrib(filout," ");
	fprintf(filout,">\n");
	WriteCommnt(filout,indent);

	if (value     ) {
		valuei=(char *) xmalloc((strlen(value)+1)*sizeof(char));
		memcpy(valuei,value,(strlen(value)+1)*sizeof(char)); 
        
		vtoken=strtok(valuei,nl);
		fprintf(filout,"%s  %s\n",indent,vtoken);
    
		while (vtoken=strtok(NULL,nl))
			fprintf(filout,"%s  %s\n",indent,vtoken);

		xfree((void**)&valuei);
	}

	KML_Object::Write(filout,indent);

	fprintf(filout,"%s</%s>\n",indent,name);

	return;
}
/*}}}*/
/*FUNCTION KML_Unknown::Read {{{*/
void  KML_Unknown::Read(FILE* fid,char* kstr){

	char*        kstri;
	int          ncom=0;
	char**       pcom=NULL;
	char         nl[]={'\n','\0'};

/*  get object name  */

	name=KMLFileTagName(NULL,
						kstr);
//	_printf_(true,"KML_Unknown::Read -- opening name=%s.\n",name);

/*  get object attributes and check for solo tag  */

	if (KMLFileTagAttrib(this,
						 kstr))
		return;

/*  loop over and process fields within opening and closing tags  */

	while (kstri=KMLFileToken(fid,
							  &ncom,&pcom)) {
//		_printf_(true,"KML_Unknown::Read -- kstri=%s.\n",kstri);
		if      (!strncmp(&kstri[0],"</", 2) &&
				 !strncmp(&kstri[2],name,strlen(name))) {
//			_printf_(true,"KML_Unknown::Read -- closing name=%s.\n",name);
			xfree((void**)&kstri);
			break;
		}
		else if (!strncmp(kstri,"</",2))
		  {_error2_("KML_Unknown::Read -- Unexpected closing tag " << kstri << ".\n");}

		else if (strncmp(kstri,"<",1)) {
			if (value) {
				value=(char *) xrealloc(value,(strlen(value)+1+strlen(kstri)+1)*sizeof(char));
				strcat(value,nl);
				strcat(value,kstri);
			}
			else {
				value=(char *) xmalloc((strlen(kstri)+1)*sizeof(char));
				memcpy(value,kstri,(strlen(kstri)+1)*sizeof(char));
			}
		}

		else if (!strncmp(kstri,"<",1))
			KML_Object::Read(fid,kstri);

		xfree((void**)&kstri);
	}

	this->AddCommnt(ncom,pcom);

	for (ncom; ncom>0; ncom--)
		xfree((void**)&(pcom[ncom-1]));
	xfree((void**)&pcom);

	return;
}
/*}}}*/
