/*!\file: types.h
 * \brief prototypes for types.h
 */ 

#ifndef _TYPES_H_
#define  _TYPES_H_


#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include <stdio.h>

/*Define abstract type for I/O: */
enum param_type { STRING, INTEGER, STRINGARRAY, DOUBLE, DOUBLEVEC, DOUBLEMAT, PETSCVEC, PETSCMAT };

/*here are our abstracted types: inspired on petsc */
#if ISSM_USE_64BIT_INDICES == 1
typedef long long IssmInt;
//#define MPIU_INT MPI_LONG_LONG_INT already define in petsc
#else
typedef int IssmInt;
//#define MPIU_INT MPI_INT already defined in petsc
#endif  

#ifdef _HAVE_ADOLC_
#include "adolc.h"
// for active variables
typedef adouble IssmDouble;
// for passive variables
typedef double IssmPDouble;
#else 
// see above
typedef double IssmDouble; 
// see above
typedef IssmDouble IssmPDouble;
#endif

typedef bool IssmBool;

#endif //ifndef _TYPES_H_
