/*!\file: thermal_core.cpp
 * \brief: core of the thermal solution 
 */ 

#include "../toolkits/toolkits.h"
#include "../objects/objects.h"
#include "../shared/shared.h"
#include "../io/io.h"
#include "../EnumDefinitions/EnumDefinitions.h"
#include "./solutions.h"
#include "../modules/modules.h"
#include "../include/include.h"
#include "../solvers/solvers.h"

void thermal_core(FemModel* femmodel){

	/*intermediary*/
	IssmDouble melting_offset;
	bool   save_results;
	bool   dakota_analysis  = false;

	//first recover parameters common to all solutions
	femmodel->parameters->FindParam(&save_results,SaveResultsEnum);
	femmodel->parameters->FindParam(&dakota_analysis,QmuIsdakotaEnum);

	if(dakota_analysis){
		femmodel->SetCurrentConfiguration(ThermalAnalysisEnum);
		ResetConstraintsx(femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters);
	}

	_printf_(VerboseSolution(),"   computing temperatures\n");
	femmodel->SetCurrentConfiguration(ThermalAnalysisEnum);
	solver_thermal_nonlinear(femmodel);

	_printf_(VerboseSolution(),"   computing melting\n");
	femmodel->SetCurrentConfiguration(MeltingAnalysisEnum);
	solver_linear(femmodel);

	if(save_results){
		_printf_(VerboseSolution(),"   saving results\n");
		InputToResultx(femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters,TemperatureEnum);
		InputToResultx(femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters,BasalforcingsMeltingRateEnum);
	}
}
