/*!\file:  SeqVec.h
 * \brief wrapper to our SeqVec object, which is just a wrapper to a IssmDouble* 
 */ 

#ifndef _SEQVEC_H_
#define _SEQVEC_H_

/*Headers:*/
/*{{{*/
#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "../toolkitsenums.h"

/*}}}*/

class SeqVec{

	public:
	
		IssmDouble* vector;
		int M;

		/*SeqVec constructors, destructors {{{*/
		SeqVec();
		SeqVec(int M,bool fromlocalsize=false);
		SeqVec(IssmDouble* buffer, int M);
		~SeqVec();
		/*}}}*/
		/*SeqVec specific routines {{{*/
		void Echo(void);
		void Assemble(void);
		void SetValues(int ssize, int* list, IssmDouble* values, InsMode mode);
		void SetValue(int dof, IssmDouble value, InsMode  mode);
		void GetValue(IssmDouble* pvalue, int dof);
		void GetSize(int* pM);
		void GetLocalSize(int* pM);
		SeqVec* Duplicate(void);
		void Set(IssmDouble value);
		void AXPY(SeqVec* X, IssmDouble a);
		void AYPX(SeqVec* X, IssmDouble a);
		IssmDouble* ToMPISerial(void);
		void Copy(SeqVec* to);
		IssmDouble Norm(NormMode norm_type);
		void Scale(IssmDouble scale_factor);
		void PointwiseDivide(SeqVec* x,SeqVec* y);
		IssmDouble Dot(SeqVec* vector);
		/*}}}*/
};

#endif //#ifndef _SEQVEC_H_
