/*! \file IntVecParam.h 
 *  \brief: header file for triavertexinput object
 */


#ifndef _INTVECPARAM_H_
#define _INTVECPARAM_H_

/*Headers:*/
/*{{{*/
#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "./Param.h"
#include "../../include/include.h"
#include "../../shared/shared.h"
/*}}}*/

class IntVecParam: public Param{

	private: 
		int enum_type;
		int* values;
		int M;

	public:
		/*IntVecParam constructors, destructors: {{{*/
		IntVecParam();
		IntVecParam(int enum_type,int* values,int M);
		IntVecParam(int enum_type,IssmDouble* values,int M);
		~IntVecParam();
		/*}}}*/
		/*Object virtual functions definitions:{{{ */
		void  Echo();
		void  DeepEcho();
		int   Id(); 
		int   MyRank();
		int   ObjectEnum();
		Object* copy();
		/*}}}*/
		/*Param virtual functions definitions: {{{*/
		int   InstanceEnum(){return enum_type;}
		void  GetParameterValue(bool* pbool){_error_("IntVec param of enum %i (%s) cannot return a bool",enum_type,EnumToStringx(enum_type));}
		void  GetParameterValue(int* pinteger){_error_("IntVec param of enum %i (%s) cannot return an integer",enum_type,EnumToStringx(enum_type));}
		void  GetParameterValue(int** pintarray,int* pM);
		void  GetParameterValue(int** pintarray,int* pM,int* pN){_error_("IntVec param of enum %i (%s) cannot return a matrix",enum_type,EnumToStringx(enum_type));}
		void  GetParameterValue(IssmDouble* pIssmDouble){_error_("IntVec param of enum %i (%s) cannot return a IssmDouble",enum_type,EnumToStringx(enum_type));}
		void  GetParameterValue(char** pstring){_error_("IntVec param of enum %i (%s) cannot return a string",enum_type,EnumToStringx(enum_type));}
		void  GetParameterValue(char*** pstringarray,int* pM){_error_("IntVec param of enum %i (%s) cannot return a string array",enum_type,EnumToStringx(enum_type));}
		void  GetParameterValue(IssmDouble** pIssmDoublearray,int* pM){_error_("IntVec param of enum %i (%s) cannot return a IssmDouble array (maybe in serial?)",enum_type,EnumToStringx(enum_type));}
		void  GetParameterValue(IssmDouble** pIssmDoublearray,int* pM, int* pN){_error_("IntVec param of enum %i (%s) cannot return a IssmDouble array",enum_type,EnumToStringx(enum_type));}
		void  GetParameterValue(IssmDouble*** parray, int* pM,int** pmdims, int** pndims){_error_("IntVec param of enum %i (%s) cannot return a matrix array",enum_type,EnumToStringx(enum_type));}
		void  GetParameterValue(Vector** pvec){_error_("IntVec param of enum %i (%s) cannot return a Vec",enum_type,EnumToStringx(enum_type));}
		void  GetParameterValue(Matrix** pmat){_error_("IntVec param of enum %i (%s) cannot return a Mat",enum_type,EnumToStringx(enum_type));}
		void  GetParameterValue(FILE** pfid){_error_("IntVec param of enum %i (%s) cannot return a FILE",enum_type,EnumToStringx(enum_type));}

		void  SetValue(bool boolean){_error_("IntVec param of enum %i (%s) cannot hold a boolean",enum_type,EnumToStringx(enum_type));}
		void  SetValue(int integer){_error_("IntVec param of enum %i (%s) cannot hold an integer",enum_type,EnumToStringx(enum_type));}
		void  SetValue(IssmDouble scalar){_error_("IntVec param of enum %i (%s) cannot hold a scalar",enum_type,EnumToStringx(enum_type));}
		void  SetValue(char* string){_error_("IntVec param of enum %i (%s) cannot hold a string",enum_type,EnumToStringx(enum_type));}
		void  SetValue(char** stringarray,int M){_error_("IntVec param of enum %i (%s) cannot hold a string array",enum_type,EnumToStringx(enum_type));}
		void  SetValue(IssmDouble* IssmDoublearray,int M){_error_("IntVec param of enum %i (%s) cannot hold a IssmDouble mat array",enum_type,EnumToStringx(enum_type));}
		void  SetValue(IssmDouble* pIssmDoublearray,int M,int N){_error_("IntVec param of enum %i (%s) cannot hold a IssmDouble mat array",enum_type,EnumToStringx(enum_type));}
		void  SetValue(int* intarray,int M);
		void  SetValue(int* pintarray,int M,int N){_error_("IntVec param of enum %i (%s) cannot hold a int mat array",enum_type,EnumToStringx(enum_type));}
		void  SetValue(Vector* vec){_error_("IntVec param of enum %i (%s) cannot hold a Vec",enum_type,EnumToStringx(enum_type));}
		void  SetValue(Matrix* mat){_error_("IntVec param of enum %i (%s) cannot hold a Mat",enum_type,EnumToStringx(enum_type));}
		void  SetValue(FILE* fid){_error_("IntVec param of enum %i (%s) cannot hold a FILE",enum_type,EnumToStringx(enum_type));}
		void  SetValue(IssmDouble** array, int M, int* mdim_array, int* ndim_array){_error_("IntVec param of enum %i (%s) cannot hold an array of matrices",enum_type,EnumToStringx(enum_type));}
		void  UnitConversion(int direction_enum);
		
		void GetParameterName(char**pname);
		/*}}}*/
};
#endif
