/*!\file InputToResultx
 * \brief: transfer an input to the results  dataset inside the elements
 */

#include "./InputToResultx.h"
#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"

void InputToResultx(Elements* elements,Nodes* nodes,Vertices* vertices,Loads* loads,Materials* materials,Parameters* parameters,int enum_type){

	/*intermediary:*/
	int      step;
	IssmDouble   time;
	Element *element = NULL;

	/*Get time and step*/
	parameters->FindParam(&step,StepEnum);
	parameters->FindParam(&time,TimeEnum);

	/*Go through elemnets, and ask each element to transfer the enum_type input into the results dataset, with step and time information: */
	for(int i=0;i<elements->Size();i++){

		element=(Element*)elements->GetObjectByOffset(i);
		element->InputToResult(enum_type,step,time);
	}

}
