/*! \file StringExternalResult.h 
 *  \brief: header file for triavertexinput object
 */


#ifndef _STRINGEXTERNALRESULT_H_
#define _STRINGEXTERNALRESULT_H_

/*Headers:*/
/*{{{*/

#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "./ExternalResult.h"
#include "../../include/include.h"
#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../include/include.h"
/*}}}*/

class StringExternalResult: public ExternalResult{

	private: 
		int    id;
		int    enum_type;
		char*  value;
		int    step;
		IssmPDouble time;

	public:
		/*StringExternalResult constructors, destructors: {{{*/
		StringExternalResult();
		StringExternalResult(int id,int enum_type,char* value,int step, IssmPDouble time);
		~StringExternalResult();
		/*}}}*/
		/*Object virtual functions definitions:{{{ */
		void  Echo();
		void  DeepEcho();
		int   Id(); 
		int   MyRank();
		int   ObjectEnum();
		Object* copy();
		/*}}}*/
		/*ExternalResult management: {{{*/
		int   InstanceEnum(){return enum_type;}
		void  WriteData(FILE* fid,bool io_gather);
		void  GetResultName(char**);
		int   GetStep(void);
		/*}}}*/
};
#endif  /* _STRINGEXTERNALRESULT_H */
