/*! \file IntExternalResult.h 
 *  \brief: header file for triavertexinput object
 */


#ifndef _INTEXTERNALRESULT_H_
#define _INTEXTERNALRESULT_H_

/*Headers:*/
/*{{{*/

#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "./ExternalResult.h"
#include "../../include/include.h"
#include "../../shared/shared.h"
/*}}}*/

class IntExternalResult: public ExternalResult{

	public:
		int    id;
		int    enum_type;
		int    value;
		int    step;
		IssmPDouble time;


		/*IntExternalResult constructors, destructors: {{{*/
		IntExternalResult();
		IntExternalResult(int id,int enum_type,int value,int step,IssmPDouble time);
		~IntExternalResult();

		/*}}}*/
		/*Object virtual functions definitions:{{{ */
		void  Echo();
		void  DeepEcho();
		int   Id(); 
		int   MyRank();
		int   ObjectEnum();
		Object* copy();
		/*}}}*/
		/*ExternalResult managemnet: {{{*/
		int   InstanceEnum(){return enum_type;}
		void  WriteData(FILE* fid,bool io_gather);
		void  GetResultName(char**);
		int   GetStep(void);
		/*}}}*/
};
#endif  /* _INTEXTERNALRESULT_H */
