/*! \file DoubleVecExternalResult.h 
 */


#ifndef _DOUBLEVECEXTERNALRESULT_H_
#define _DOUBLEVECEXTERNALRESULT_H_

/*Headers:*/
/*{{{*/

#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "./ExternalResult.h"
#include "../../include/include.h"
#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../include/include.h"
/*}}}*/

class DoubleVecExternalResult: public ExternalResult{

	private: 
		int id;
		int enum_type;
		IssmPDouble* values;
		int M;
		int step;
		IssmPDouble time;

	public:
		/*DoubleVecExternalResult constructors, destructors: {{{*/
		DoubleVecExternalResult();
		DoubleVecExternalResult(int id,int enum_type,IssmPDouble* values,int M,int step, IssmPDouble time);
		~DoubleVecExternalResult();
		/*}}}*/
		/*Object virtual functions definitions:{{{ */
		void  Echo();
		void  DeepEcho();
		int   Id(); 
		int   MyRank();
		int   ObjectEnum();
		Object* copy();
		/*}}}*/
		/*ExternalResult management: {{{*/
		int   InstanceEnum(){return enum_type;}
		void  WriteData(FILE* fid,bool io_gather);
		void  GetResultName(char**);
		int   GetStep(void);
		/*}}}*/
};
#endif  /* _DOUBLEVECEXTERNALRESULT_H */
