/*!\file StringParam.c
 * \brief: implementation of the StringParam object
 */

/*header files: */
/*{{{*/
#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include <stdio.h>
#include <string.h>
#include "../objects.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../shared/shared.h"
#include "../../Container/Container.h"
#include "../../include/include.h"
/*}}}*/

/*StringParam constructors and destructor*/
/*FUNCTION StringParam::StringParam(){{{*/
StringParam::StringParam(){
	return;
}
/*}}}*/
/*FUNCTION StringParam::StringParam(int enum_type,IssmString value){{{*/
StringParam::StringParam(int in_enum_type,char* in_value){

	enum_type=in_enum_type;
	value=xNew<char>(strlen(in_value)+1);
	memcpy(value,in_value,(strlen(in_value)+1)*sizeof(char));

	
}
/*}}}*/
/*FUNCTION StringParam::~StringParam(){{{*/
StringParam::~StringParam(){
	xDelete<char>(value);
}
/*}}}*/

/*Object virtual functions definitions:*/
/*FUNCTION StringParam::Echo {{{*/
void StringParam::Echo(void){
	this->DeepEcho();
}
/*}}}*/
/*FUNCTION StringParam::DeepEcho{{{*/
void StringParam::DeepEcho(void){
	printf("StringParam:\n");
	printf("   enum:  %i (%s)\n",this->enum_type,EnumToStringx(this->enum_type));
	printf("   value: %s\n",this->value);
}
/*}}}*/
/*FUNCTION StringParam::Id{{{*/
int    StringParam::Id(void){ return -1; }
/*}}}*/
/*FUNCTION StringParam::MyRank{{{*/
int    StringParam::MyRank(void){ 
	extern int my_rank;
	return my_rank; 
}
/*}}}*/
/*FUNCTION StringParam::ObjectEnum{{{*/
int StringParam::ObjectEnum(void){

	return StringParamEnum;

}
/*}}}*/
/*FUNCTION StringParam::copy{{{*/
Object* StringParam::copy() {
	
	return new StringParam(this->enum_type,this->value);

}
/*}}}*/

/*StringParam virtual functions definitions: */
/*FUNCTION StringParam::GetParameterValue{{{*/
void  StringParam::GetParameterValue(char** pstring){
	
	char* outstring=NULL;
	int   stringsize;

	stringsize=strlen(this->value)+1;

	outstring=xNew<char>(stringsize);
	memcpy(outstring,this->value,stringsize*sizeof(char));

	*pstring=outstring;

}
/*}}}*/
/*FUNCTION StringParam::GetParameterName{{{*/
void StringParam::GetParameterName(char**pname){
	EnumToStringx(pname,this->enum_type);
}
/*}}}*/
/*FUNCTION StringParam::SetValue{{{*/
void  StringParam::SetValue(char* string){
	
	int   stringsize;
	
	/*avoid leak: */
	xDelete<char>(this->value);

	/*copy: */
	stringsize=strlen(string)+1;
	this->value=xNew<char>(stringsize);
	memcpy(this->value,string,stringsize*sizeof(char));

}
/*}}}*/
/*FUNCTION StringParam::UnitConversion{{{*/
void  StringParam::UnitConversion(int direction_enum){
	/*do nothing, no unit conversion*/
}
/*}}}*/
