/*!\file: CreateParametersDakota.cpp
 * \brief general driver for creating parameters dataset
 */ 

#include "../../../Container/Container.h"
#include "../../../toolkits/toolkits.h"
#include "../../../EnumDefinitions/EnumDefinitions.h"
#include "../../../objects/objects.h"
#include "../../../shared/shared.h"
#include "../../../io/io.h"
#include "../../../include/include.h"
#include "../../MeshPartitionx/MeshPartitionx.h"
#include "../ModelProcessorx.h"

void CreateParametersDakota(Parameters** pparameters,IoModel* iomodel,int solution_type,int analysis_type){

	/*variable declarations: {{{*/
	int i,j,k;
	
	Parameters* parameters = NULL;
	int      second_count;
	
	int*     part=NULL;
	double*  dpart=NULL;

	char**  responsedescriptors=NULL;
	int     numresponsedescriptors;
	char**  variabledescriptors=NULL;
	int     numvariabledescriptors;
	char*   descriptor=NULL;
	double* dakota_parameter=NULL;

	//qmu files
	char* qmuinname=NULL;
	char* qmuerrname=NULL;
	char* qmuoutname=NULL;
	
	//descriptors:
	char tag[50];
	
	/*parameters for mass flux: */
	bool     qmu_mass_flux_present=false;
	int qmu_mass_flux_num_profiles=0;
	double** array=NULL;
	int*     mdims_array=NULL;
	int*     ndims_array=NULL;
	
	double*  matrix=NULL;
	double*  temp_matrix=NULL;
	int      M;
	int      temp_m,temp_n;
	int      m,n;
	int      count;
	bool     dakota_analysis=false;
	char*    name=NULL;
	int      numberofresponses;
	int      numberofvertices;
	int      nrows;
	int      ncols;

	/*}}}*/
	
	/*recover parameters : */
	parameters=*pparameters;

	/*recover parameters: */
	iomodel->Constant(&dakota_analysis,QmuIsdakotaEnum);

	if(dakota_analysis){

		iomodel->Constant(&name,MiscellaneousNameEnum);
		iomodel->Constant(&numberofresponses,QmuNumberofresponsesEnum);
		iomodel->Constant(&numberofvertices,MeshNumberofverticesEnum);

		/*name of qmu input, error and output files:{{{*/
		qmuinname=xNew<char>((strlen(name)+strlen(".qmu.in")+1));
		sprintf(qmuinname,"%s%s",name,".qmu.in");
		parameters->AddObject(new   StringParam(QmuInNameEnum,qmuinname));

		qmuoutname=xNew<char>((strlen(name)+strlen(".qmu.out")+1));
		sprintf(qmuoutname,"%s%s",name,".qmu.out");
		parameters->AddObject(new   StringParam(QmuOutNameEnum,qmuoutname));

		qmuerrname=xNew<char>((strlen(name)+strlen(".qmu.err")+1));
		sprintf(qmuerrname,"%s%s",name,".qmu.err");
		parameters->AddObject(new   StringParam(QmuErrNameEnum,qmuerrname));
		/*}}}*/
		/*Fetch variable descriptors: {{{*/
		iomodel->FetchData(&variabledescriptors,&numvariabledescriptors,QmuVariabledescriptorsEnum);

		/*Ok, we have all the variable descriptors. Build a parameter with it: */
		parameters->AddObject(new StringArrayParam(QmuVariabledescriptorsEnum,variabledescriptors,numvariabledescriptors));

		/*}}}*/
		/*Fetch response descriptors: {{{*/
		iomodel->FetchData(&responsedescriptors,&numresponsedescriptors,QmuResponsedescriptorsEnum);

		/*Ok, we have all the response descriptors. Build a parameter with it: */
		parameters->AddObject(new StringArrayParam(QmuResponsedescriptorsEnum,responsedescriptors,numresponsedescriptors));
		parameters->AddObject(new    IntParam(QmuNumberofresponsesEnum,numberofresponses));
		/*}}}*/
		/*Deal with partitioning: {{{*/
		/*partition vertices in iomodel->qmu_npart parts, unless a partition is already present: */
		
		parameters->AddObject(iomodel->CopyConstantObject(QmuNumberofpartitionsEnum));
		iomodel->FetchData(&dpart,NULL,NULL,QmuPartitionEnum);

		if(!dpart){

			/*Partition elements and vertices and nodes: */
			ElementsAndVerticesPartitioning(&iomodel->my_elements,&iomodel->my_vertices,iomodel);

			dpart=xNew<double>(numberofvertices);
			for(i=0;i<numberofvertices;i++)dpart[i]=iomodel->my_vertices[i];
		}
		parameters->AddObject(new DoubleVecParam(QmuPartitionEnum,dpart,numberofvertices));
		/*}}}*/
		/*Deal with data needed because of qmu variables: {{{*/
		
		for(i=0;i<numvariabledescriptors;i++){

			if (strncmp(variabledescriptors[i],"scaled_",7)==0){
				/*Ok, we are dealing with a variable that is distributed over nodes. Recover the name of the variable (ex: scaled_Thickness): */
				sscanf(variabledescriptors[i],"scaled_%s",tag);
				
				/*Recover data: */
				iomodel->FetchData(&dakota_parameter,&nrows,&ncols,StringToEnumx(tag));

				/*Add to parameters: */
				if(nrows==numberofvertices){
					parameters->AddObject(new DoubleMatParam(StringToEnumx(tag),dakota_parameter,nrows,ncols));
				}
				else{
					parameters->AddObject(new DoubleTransientMatParam(StringToEnumx(tag),dakota_parameter,nrows,ncols));
				}
				
				/*Free ressources:*/
				xDelete<double>(dakota_parameter);
			}
		}
		/*}}}*/
		/*Deal with data needed to compute qmu responses: {{{*/
		for(i=0;i<numresponsedescriptors;i++){
			
			if(strncmp(responsedescriptors[i],"indexed_MassFlux",16)==0){
				qmu_mass_flux_present=true;
			}
		}
		
		
		if(qmu_mass_flux_present){
			
			/*Fetch the mass flux segments necessary to compute the mass fluxes.  Build a DoubleMatArrayParam object out of them: */ 
			iomodel->FetchData(&array,&mdims_array,&ndims_array,&qmu_mass_flux_num_profiles,QmuMassFluxSegmentsEnum);
			if(qmu_mass_flux_num_profiles==0)_error_(" qmu_mass_flux_num_profiles is 0, when MassFlux computations were requested!");

			/*Go through segments, and extract those that belong to this cpu: */
			for(i=0;i<qmu_mass_flux_num_profiles;i++){
				temp_matrix=array[i];
				temp_m=mdims_array[i];
				temp_n=ndims_array[i];

				m=0;
				for(j=0;j<temp_m;j++){
					if (  iomodel->my_elements[(int)(*(temp_matrix+5*j+4))-1])m++;
				}
				if(m){
					matrix=xNewZeroInit<double>(5*m);
					count=0;
					for(j=0;j<temp_m;j++){
						if (iomodel->my_elements[(int)*(temp_matrix+5*j+4)-1]){
							for(k=0;k<5;k++)*(matrix+5*count+k)=*(temp_matrix+5*j+k);
							count++;
						}
					}
				}
				else{
					matrix=NULL;
				}

				/*Assign: */
				array[i]=matrix;
				mdims_array[i]=m;
				ndims_array[i]=5;

				/*Free temporary matrix: */
				xDelete<double>(temp_matrix);
			}

			/*Ok, we have an array of segments, different on every cpu. Create a DoubleMatArrayParam object with it: */
			parameters->AddObject(new DoubleMatArrayParam(QmuMassFluxSegmentsEnum,array,qmu_mass_flux_num_profiles,mdims_array,ndims_array));

			/*Free data: */
			for(i=0;i<qmu_mass_flux_num_profiles;i++){
				double* matrix=array[i];
				xDelete<double>(matrix);
			}
			xDelete<int>(mdims_array); 
			xDelete<int>(ndims_array);
			xDelete<double*>(array);
		}
		/*}}}*/
		/*Free data: {{{*/
		for(i=0;i<numresponsedescriptors;i++){
			descriptor=responsedescriptors[i];
			xDelete<char>(descriptor);
		}
		xDelete<char*>(responsedescriptors);

		for(i=0;i<numvariabledescriptors;i++){
			descriptor=variabledescriptors[i];
			xDelete<char>(descriptor);
		}
		xDelete<char*>(variabledescriptors);
		xDelete<int>(part);
		xDelete<double>(dpart);
		xDelete<char>(qmuinname);
		xDelete<char>(qmuerrname);
		xDelete<char>(qmuoutname);
		/*}}}*/
	} //if(dakota_analysis)

	/*Free data*/
	xDelete<char>(name);

	/*Assign output pointer: */
	*pparameters=parameters;
}
