/*!\file MPI_Boundariesfromrange.cpp
 * \brief: routine to figure out from a range distribution, the lower and upper 
 * bounds for the current cpu.
 */

#include "./mpipatches.h"
#include "../../../shared/shared.h"

int MPI_Boundariesfromrange(int* plower_row, int* pupper_row,int range){

	extern int num_procs;
	extern int my_rank;
	
	/*output: */
	int lower_row,upper_row;

	/*intermediary: */
	int  i;
	int* allranges=NULL;

	/*Gather all range values into allranges, for all nodes*/
	allranges=xNew<int>(num_procs);
	MPI_Allgather(&range,1,MPI_INT,allranges,1,MPI_INT,MPI_COMM_WORLD);

	/*From all ranges, get lower row and upper row*/
	lower_row=0;
	upper_row=lower_row+allranges[0];
	for (i=1;i<=my_rank;i++){
		lower_row=lower_row+allranges[i-1];
		upper_row=upper_row+allranges[i];
	}

	/*Assign output pointers: */
	xDelete<int>(allranges);
	*plower_row=lower_row;
	*pupper_row=upper_row;
	return 1;
}
