/*!\file:  Input.h
 * \brief abstract class for Input object
 */ 


#ifndef _INPUT_H_
#define _INPUT_H_

/*Headers:*/
/*{{{*/
#include "../Object.h"
class Node;
class ElementResult;
class GaussTria;
class Parameters;
/*}}}*/

class Input: public Object{

	public: 
		
		virtual        ~Input(){};
		/*Virtual functions:{{{*/
		virtual int  InstanceEnum()=0; 
		virtual void GetInputValue(bool* pvalue)=0;
		virtual void GetInputValue(int* pvalue)=0;
		virtual void GetInputValue(IssmPDouble* pvalue)=0;
		virtual void GetInputValue(IssmPDouble* pvalue,GaussTria* gauss)=0;
		virtual void GetInputValue(IssmPDouble* pvalue,GaussTria* gauss,IssmPDouble time)=0;
		virtual void GetInputValue(IssmPDouble* pvalue,GaussPenta* gauss)=0;
		virtual void GetInputValue(IssmPDouble* pvalue,GaussTria* gauss ,int index)=0;
		virtual void GetInputValue(IssmPDouble* pvalue,GaussPenta* gauss,int index)=0;
		virtual void GetInputDerivativeValue(IssmPDouble* derivativevalues, IssmPDouble* xyz_list, GaussTria* gauss)=0;
		virtual void GetInputDerivativeValue(IssmPDouble* derivativevalues, IssmPDouble* xyz_list, GaussPenta* gauss)=0;
		virtual void GetInputAverage(IssmPDouble* pvalue)=0;
		virtual void GetVxStrainRate2d(IssmPDouble* epsilonvx,IssmPDouble* xyz_list, GaussTria* gauss)=0;
		virtual void GetVyStrainRate2d(IssmPDouble* epsilonvy,IssmPDouble* xyz_list, GaussTria* gauss)=0;
		virtual void GetVxStrainRate3d(IssmPDouble* epsilonvx,IssmPDouble* xyz_list, GaussPenta* gauss)=0;
		virtual void GetVyStrainRate3d(IssmPDouble* epsilonvy,IssmPDouble* xyz_list, GaussPenta* gauss)=0;
		virtual void GetVzStrainRate3d(IssmPDouble* epsilonvz,IssmPDouble* xyz_list, GaussPenta* gauss)=0;
		virtual void GetVxStrainRate3dPattyn(IssmPDouble* epsilonvx,IssmPDouble* xyz_list, GaussPenta* gauss)=0;
		virtual void GetVyStrainRate3dPattyn(IssmPDouble* epsilonvy,IssmPDouble* xyz_list, GaussPenta* gauss)=0;
		virtual void ChangeEnum(int newenumtype)=0;
		virtual void Configure(Parameters* parameters)=0;

		virtual void   SquareMin(IssmPDouble* psquaremin, bool process_units,Parameters* parameters)=0;
		virtual void   ConstrainMin(IssmPDouble minimum)=0;
		virtual IssmPDouble InfinityNorm(void)=0;
		virtual IssmPDouble MaxAbs(void)=0;
		virtual IssmPDouble MinAbs(void)=0;
		virtual IssmPDouble Max(void)=0;
		virtual IssmPDouble Min(void)=0;
		virtual void   Scale(IssmPDouble scale_factor)=0;
		virtual void   ArtificialNoise(IssmPDouble min,IssmPDouble max)=0;
		virtual void   AXPY(Input* xinput,IssmPDouble scalar)=0;
		virtual void   Constrain(IssmPDouble cm_min, IssmPDouble cm_max)=0;
		virtual void   VerticallyIntegrate(Input* thickness_input)=0;
		virtual void   Extrude()=0;
		virtual void   GetVectorFromInputs(Vector* vector,int* doflist)=0;
		virtual void   GetValuesPtr(IssmPDouble** pvalues,int* pnum_values)=0;
		
		virtual Input* SpawnTriaInput(int* indices)=0;
		virtual Input* PointwiseDivide(Input* inputB)=0;
		virtual Input* PointwiseMax(Input* inputmax)=0;
		virtual Input* PointwiseMin(Input* inputmin)=0;
		virtual ElementResult* SpawnResult(int step, IssmPDouble time)=0;

		/*}}}*/

};
#endif
