/*! \file DoubleInput.h 
 *  \brief: header file for triavertexinput object
 */


#ifndef _DOUBLEINPUT_H_
#define _DOUBLEINPUT_H_

/*Headers:*/
/*{{{*/
#include "./Input.h"
#include "../../include/include.h"
class GaussTria;
/*}}}*/

class DoubleInput: public Input{

	public:
		int    enum_type;
		IssmPDouble value;

		/*DoubleInput constructors, destructors: {{{*/
		DoubleInput();
		DoubleInput(int enum_type,IssmDouble value);
		~DoubleInput();
		/*}}}*/
		/*Object virtual functions definitions:{{{ */
		void  Echo();
		void  DeepEcho();
		int   Id(); 
		int   MyRank();
		int   ObjectEnum();
		Object* copy();
		/*}}}*/
		/*DoubleInput management: {{{*/
		int   InstanceEnum();
		Input* SpawnTriaInput(int* indices);
		Input* PointwiseDivide(Input* inputB);
		Input* PointwiseMin(Input* inputB);
		Input* PointwiseMax(Input* inputB);
		ElementResult* SpawnResult(int step, IssmPDouble time);
		void AddTimeValues(IssmPDouble* values,int step,IssmPDouble time){_error_("not supported yet");};
		void Configure(Parameters* parameters);
		/*}}}*/
		/*numerics: {{{*/
		void GetInputValue(bool* pvalue);
		void GetInputValue(int* pvalue);
		void GetInputValue(IssmPDouble* pvalue);
		void GetInputValue(IssmPDouble* pvalue,GaussTria* gauss);
		void GetInputValue(IssmPDouble* pvalue,GaussTria* gauss,IssmPDouble time){_error_("not implemented yet");};
		void GetInputValue(IssmPDouble* pvalue,GaussPenta* gauss);
		void GetInputValue(IssmPDouble* pvalue,GaussTria* gauss ,int index){_error_("not implemented yet");};
		void GetInputValue(IssmPDouble* pvalue,GaussPenta* gauss ,int index){_error_("not implemented yet");};
		void GetInputDerivativeValue(IssmPDouble* derivativevalues, IssmPDouble* xyz_list, GaussTria* gauss);
		void GetInputDerivativeValue(IssmPDouble* derivativevalues, IssmPDouble* xyz_list, GaussPenta* gauss);
		void GetInputAverage(IssmPDouble* pvalue);
		void GetVxStrainRate2d(IssmPDouble* epsilonvx,IssmPDouble* xyz_list, GaussTria* gauss);
		void GetVyStrainRate2d(IssmPDouble* epsilonvy,IssmPDouble* xyz_list, GaussTria* gauss);
		void GetVxStrainRate3d(IssmPDouble* epsilonvx,IssmPDouble* xyz_list, GaussPenta* gauss);
		void GetVyStrainRate3d(IssmPDouble* epsilonvy,IssmPDouble* xyz_list, GaussPenta* gauss);
		void GetVzStrainRate3d(IssmPDouble* epsilonvz,IssmPDouble* xyz_list, GaussPenta* gauss);
		void GetVxStrainRate3dPattyn(IssmPDouble* epsilonvx,IssmPDouble* xyz_list, GaussPenta* gauss);
		void GetVyStrainRate3dPattyn(IssmPDouble* epsilonvy,IssmPDouble* xyz_list, GaussPenta* gauss);
		void ChangeEnum(int newenumtype);
		void SquareMin(IssmPDouble* psquaremin, bool process_units,Parameters* parameters);
		void ConstrainMin(IssmPDouble minimum);
		void Scale(IssmPDouble scale_factor);
		void ArtificialNoise(IssmPDouble min,IssmPDouble max){_error_("not implemented yet");};
		void AXPY(Input* xinput,IssmPDouble scalar);
		void Constrain(IssmPDouble cm_min, IssmPDouble cm_max);
		IssmPDouble InfinityNorm(void){_error_("not implemented yet");};
		IssmPDouble Max(void);
		IssmPDouble MaxAbs(void);
		IssmPDouble Min(void);
		IssmPDouble MinAbs(void);
		void Extrude(void){_error_("not supported yet");};
		void VerticallyIntegrate(Input* thickness_input);
		void GetVectorFromInputs(Vector* vector,int* doflist);
		void GetValuesPtr(IssmPDouble** pvalues,int* pnum_values);
		/*}}}*/

};
#endif  /* _DOUBLEINPUT_H */
