/*!\file BoolInput.c
 * \brief: implementation of the BoolInput object
 */

#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include <stdio.h>
#include <string.h>
#include "../objects.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../shared/shared.h"
#include "../../Container/Container.h"
#include "../../include/include.h"

/*BoolInput constructors and destructor*/
/*FUNCTION BoolInput::BoolInput(){{{*/
BoolInput::BoolInput(){
	return;
}
/*}}}*/
/*FUNCTION BoolInput::BoolInput(IssmPDouble* values){{{*/
BoolInput::BoolInput(int in_enum_type,IssmBool in_value){

	enum_type=in_enum_type;
	value=in_value;
}
/*}}}*/
/*FUNCTION BoolInput::~BoolInput(){{{*/
BoolInput::~BoolInput(){
	return;
}
/*}}}*/

/*Object virtual functions definitions:*/
/*FUNCTION BoolInput::Echo {{{*/
void BoolInput::Echo(void){
	this->DeepEcho();
}
/*}}}*/
/*FUNCTION BoolInput::DeepEcho{{{*/
void BoolInput::DeepEcho(void){

	printf("BoolInput:\n");
	printf("   enum: %i (%s)\n",this->enum_type,EnumToStringx(this->enum_type));
	printf("   value: %s\n",value?"true":"false");
}
/*}}}*/
/*FUNCTION BoolInput::Id{{{*/
int    BoolInput::Id(void){ return -1; }
/*}}}*/
/*FUNCTION BoolInput::MyRank{{{*/
int    BoolInput::MyRank(void){ 
	extern int my_rank;
	return my_rank; 
}
/*}}}*/
/*FUNCTION BoolInput::ObjectEnum{{{*/
int BoolInput::ObjectEnum(void){

	return BoolInputEnum;

}
/*}}}*/
/*FUNCTION BoolInput::copy{{{*/
Object* BoolInput::copy() {
	
	return new BoolInput(this->enum_type,this->value);

}
/*}}}*/
	
/*BoolInput management*/
/*FUNCTION BoolInput::InstanceEnum{{{*/
int BoolInput::InstanceEnum(void){

	return this->enum_type;

}
/*}}}*/
/*FUNCTION BoolInput::SpawnTriaInput{{{*/
Input* BoolInput::SpawnTriaInput(int* indices){

		/*output*/
		BoolInput* outinput=new BoolInput();

		/*only copy current value*/
		outinput->enum_type=this->enum_type;
		outinput->value=this->value;

		/*Assign output*/
		return outinput;

}
/*}}}*/
/*FUNCTION BoolInput::SpawnResult{{{*/
ElementResult* BoolInput::SpawnResult(int step, IssmPDouble time){
	
	return new BoolElementResult(this->enum_type,this->value,step,time);

}
/*}}}*/

/*Object functions*/
/*FUNCTION BoolInput::GetInputValue(bool* pvalue) {{{*/
void BoolInput::GetInputValue(bool* pvalue){
	*pvalue=value;
}
/*}}}*/
/*FUNCTION BoolInput::GetInputValue(int* pvalue){{{*/
void BoolInput::GetInputValue(int* pvalue){_error_(" not supported yet!");}
/*}}}*/
/*FUNCTION BoolInput::GetInputValue(IssmPDouble* pvalue){{{*/
void BoolInput::GetInputValue(IssmPDouble* pvalue){_error_(" not supported yet!");}
/*}}}*/
/*FUNCTION BoolInput::GetInputValue(IssmPDouble* pvalue,GaussTria* gauss){{{*/
void BoolInput::GetInputValue(IssmPDouble* pvalue,GaussTria* gauss){_error_(" not supported yet!");}
/*}}}*/
/*FUNCTION BoolInput::GetInputValue(IssmPDouble* pvalue,GaussPenta* gauss){{{*/
void BoolInput::GetInputValue(IssmPDouble* pvalue,GaussPenta* gauss){_error_(" not supported yet!");}
/*}}}*/
/*FUNCTION BoolInput::GetInputDerivativeValue(IssmPDouble* derivativevalues, IssmPDouble* xyz_list, GaussTria* gauss){{{*/
void BoolInput::GetInputDerivativeValue(IssmPDouble* derivativevalues, IssmPDouble* xyz_list, GaussTria* gauss){_error_(" not supported yet!");}
/*}}}*/
/*FUNCTION BoolInput::GetInputDerivativeValue(IssmPDouble* derivativevalues, IssmPDouble* xyz_list, GaussPenta* gauss){{{*/
void BoolInput::GetInputDerivativeValue(IssmPDouble* derivativevalues, IssmPDouble* xyz_list, GaussPenta* gauss){_error_(" not supported yet!");}
/*}}}*/
/*FUNCTION BoolInput::ChangeEnum{{{*/
void BoolInput::ChangeEnum(int newenumtype){
	this->enum_type=newenumtype;
}
/*}}}*/
/*FUNCTION BoolInput::SquareMin{{{*/
void BoolInput::SquareMin(IssmPDouble* psquaremin, bool process_units,Parameters* parameters){
	/*square of a bool is the bool itself: */
	*psquaremin=value;
}
/*}}}*/
/*FUNCTION BoolInput::Scale{{{*/
void BoolInput::Scale(IssmPDouble scale_factor){
	/*a bool cannot be scaled: */
}
/*}}}*/
/*FUNCTION BoolInput::AXPY{{{*/
void BoolInput::AXPY(Input* xinput,IssmPDouble scalar){

	BoolInput*  xboolinput=NULL;

	/*xinput is of the same type, so cast it: */
	xboolinput=(BoolInput*)xinput;

	/*Carry out the AXPY operation depending on type:*/
	switch(xinput->ObjectEnum()){

		case BoolInputEnum:
			this->value=(bool)(this->value+scalar*xboolinput->value);
			return;

		default:
			_error_("not implemented yet");
	}

}
/*}}}*/
/*FUNCTION BoolInput::Constrain{{{*/
void BoolInput::Constrain(IssmPDouble cm_min, IssmPDouble cm_max){

	if(!isnan(cm_min)) if (this->value<cm_min)this->value=cm_min;
	if(!isnan(cm_max)) if (this->value>cm_max)this->value=cm_max;

}
/*}}}*/
/*FUNCTION BoolInput::Extrude{{{*/
void BoolInput::Extrude(void){

	/*do nothing*/
	return;
}
/*}}}*/
/*FUNCTION BoolInput::GetVectorFromInputs{{{*/
void BoolInput::GetVectorFromInputs(Vector* vector,int* doflist){

	_error_(" not supporte yet!");

}
/*}}}*/
/*FUNCTION BoolInput::GetValuesPtr{{{*/
void BoolInput::GetValuesPtr(IssmPDouble** pvalues,int* pnum_values){

	_error_(" not supported yet!");

}
/*}}}*/
/*FUNCTION BoolInput::Configure{{{*/
void BoolInput::Configure(Parameters* parameters){
	/*do nothing: */
}
/*}}}*/
