/*! \file TransientInput.h 
 *  \brief: header file for transientinput object
 */


#ifndef _TRANSIENTINPUT_H_
#define _TRANSIENTINPUT_H_

/*Headers:*/
/*{{{*/
#include "./Input.h"
class GaussTria;
class Parameters;
/*}}}*/

class TransientInput: public Input{

	public:
		int     enum_type;
		int     numtimesteps;
		Inputs* inputs;
		IssmPDouble* timesteps;
		Parameters* parameters; //to find current time.

		/*TransientInput constructors, destructors: {{{*/
		TransientInput();
		TransientInput(int enum_type);
		~TransientInput();
		void AddTimeInput(Input* input,IssmPDouble time);
		/*}}}*/
		/*Object virtual functions definitions:{{{*/
		void  Echo();
		void  DeepEcho();
		int   Id();
		int   MyRank();
		int   ObjectEnum();
		Object* copy();
		/*}}}*/
		/*TransientInput management: {{{*/
		int    InstanceEnum();
		Input* SpawnTriaInput(int* indices);
		Input* PointwiseDivide(Input* forcingB){_error_("not implemented yet");};
		Input* PointwiseMin(Input* forcingB){_error_("not implemented yet");};
		Input* PointwiseMax(Input* forcingB){_error_("not implemented yet");};
		ElementResult* SpawnResult(int step, IssmPDouble time);
		void Configure(Parameters* parameters);
		/*}}}*/
		/*numerics: {{{*/
		void GetInputValue(bool* pvalue){_error_("not implemented yet");};
		void GetInputValue(int* pvalue){_error_("not implemented yet");};
		void GetInputValue(IssmPDouble* pvalue){_error_("not implemented yet");};
		void GetInputValue(IssmPDouble* pvalue,GaussTria* gauss);
		void GetInputValue(IssmPDouble* pvalue,GaussTria* gauss,IssmPDouble time);
		void GetInputValue(IssmPDouble* pvalue,GaussPenta* gauss){_error_("not implemented yet");};
		void GetInputValue(IssmPDouble* pvalue,GaussTria* gauss ,int index){_error_("not implemented yet");};
		void GetInputValue(IssmPDouble* pvalue,GaussPenta* gauss ,int index){_error_("not implemented yet");};
		void GetInputDerivativeValue(IssmPDouble* derivativevalues, IssmPDouble* xyz_list, GaussTria* gauss);
		void GetInputDerivativeValue(IssmPDouble* derivativevalues, IssmPDouble* xyz_list, GaussPenta* gauss){_error_("not implemented yet");};
		void GetInputAverage(IssmPDouble* pvalue);
		void GetVxStrainRate2d(IssmPDouble* epsilonvx,IssmPDouble* xyz_list, GaussTria* gauss){_error_("not implemented yet");};
		void GetVyStrainRate2d(IssmPDouble* epsilonvy,IssmPDouble* xyz_list, GaussTria* gauss){_error_("not implemented yet");};
		void GetVxStrainRate3d(IssmPDouble* epsilonvx,IssmPDouble* xyz_list, GaussPenta* gauss){_error_("not implemented yet");};
		void GetVyStrainRate3d(IssmPDouble* epsilonvy,IssmPDouble* xyz_list, GaussPenta* gauss){_error_("not implemented yet");};
		void GetVzStrainRate3d(IssmPDouble* epsilonvz,IssmPDouble* xyz_list, GaussPenta* gauss){_error_("not implemented yet");};
		void GetVxStrainRate3dPattyn(IssmPDouble* epsilonvx,IssmPDouble* xyz_list, GaussPenta* gauss){_error_("not implemented yet");};
		void GetVyStrainRate3dPattyn(IssmPDouble* epsilonvy,IssmPDouble* xyz_list, GaussPenta* gauss){_error_("not implemented yet");};
		void ChangeEnum(int newenumtype);

		void SquareMin(IssmPDouble* psquaremin, bool process_units,Parameters* parameters);
		void ConstrainMin(IssmPDouble minimum){_error_("not implemented yet");};
		void Scale(IssmPDouble scale_factor){_error_("not implemented yet");};
		void ArtificialNoise(IssmPDouble min,IssmPDouble max){_error_("not implemented yet");};
		void AXPY(Input* xforcing,IssmPDouble scalar){_error_("not implemented yet");};
		void Constrain(IssmPDouble cm_min, IssmPDouble cm_max){_error_("not implemented yet");};
		IssmPDouble InfinityNorm(void);
		IssmPDouble Max(void);
		IssmPDouble MaxAbs(void);
		IssmPDouble Min(void);
		IssmPDouble MinAbs(void);
		void Extrude(void){_error_("not supported yet");}
		void VerticallyIntegrate(Input* thickness_forcing){_error_("not supported yet");};
		void GetVectorFromInputs(Vector* vector,int* doflist);
		void GetValuesPtr(IssmPDouble** pvalues,int* pnum_values){_error_("not supported yet");};
      void GetTimeValues(IssmPDouble* values,IssmPDouble time){_error_("not implemented yet");};
		Input* GetTimeInput(IssmPDouble time);
		/*}}}*/

};
#endif  /* _TRANSIENTINPUT_H */
