/*! \file ControlInput.h 
 *  \brief: header file for triavertexinput object
 */


#ifndef _CONTROLINPUT_H_
#define _CONTROLINPUT_H_

/*Headers:*/
/*{{{*/
#include "./Input.h"
#include "../../include/include.h"
class GaussTria;
/*}}}*/

class ControlInput: public Input{

	public:
		int    enum_type;
		int    control_id;
		Input* values;
		Input* savedvalues;
		Input* minvalues;
		Input* maxvalues;
		Input* gradient;

		/*ControlInput constructors, destructors: {{{*/
		ControlInput();
		ControlInput(int enum_type,int enum_input,IssmPDouble* pvalues,IssmPDouble* pmin,IssmPDouble* pmax,int id);
		~ControlInput();
		/*}}}*/
		/*Object virtual functions definitions:{{{ */
		void  Echo();
		void  DeepEcho();
		int   Id(); 
		int   MyRank();
		int   ObjectEnum();
		Object* copy();
		/*}}}*/
		/*ControlInput management: {{{*/
		int    InstanceEnum();
		Input* SpawnTriaInput(int* indices);
		Input* PointwiseDivide(Input* inputB){_error_("not implemented yet");};
		Input* PointwiseMin(Input* inputB){_error_("not implemented yet");};
		Input* PointwiseMax(Input* inputB){_error_("not implemented yet");};
		ElementResult* SpawnResult(int step, IssmPDouble time);
		void AddTimeValues(IssmPDouble* values,int step,IssmPDouble time){_error_("not supported yet");};
		void Configure(Parameters* parameters);
		/*}}}*/
		/*numerics: {{{*/
		void SetInput(Input* in_input);
		void GetInputValue(bool* pvalue);
		void GetInputValue(int* pvalue);
		void GetInputValue(IssmPDouble* pvalue);
		void GetInputValue(IssmPDouble* pvalue,GaussTria* gauss);
		void GetInputValue(IssmPDouble* pvalue,GaussTria* gauss,IssmPDouble time){_error_("not implemented yet");};
		void GetInputValue(IssmPDouble* pvalue,GaussPenta* gauss);
		void GetInputValue(IssmPDouble* pvalue,GaussTria* gauss ,int index){_error_("not implemented yet");};
		void GetInputValue(IssmPDouble* pvalue,GaussPenta* gauss ,int index){_error_("not implemented yet");};
		void GetInputDerivativeValue(IssmPDouble* derivativevalues, IssmPDouble* xyz_list, GaussTria* gauss);
		void GetInputDerivativeValue(IssmPDouble* derivativevalues, IssmPDouble* xyz_list, GaussPenta* gauss);
		void GetInputAverage(IssmPDouble* pvalue);
		void GetVxStrainRate2d(IssmPDouble* epsilonvx,IssmPDouble* xyz_list, GaussTria* gauss){_error_("not implemented yet");};
		void GetVyStrainRate2d(IssmPDouble* epsilonvy,IssmPDouble* xyz_list, GaussTria* gauss){_error_("not implemented yet");};
		void GetVxStrainRate3d(IssmPDouble* epsilonvx,IssmPDouble* xyz_list, GaussPenta* gauss){_error_("not implemented yet");};
		void GetVyStrainRate3d(IssmPDouble* epsilonvy,IssmPDouble* xyz_list, GaussPenta* gauss){_error_("not implemented yet");};
		void GetVzStrainRate3d(IssmPDouble* epsilonvz,IssmPDouble* xyz_list, GaussPenta* gauss){_error_("not implemented yet");};
		void GetVxStrainRate3dPattyn(IssmPDouble* epsilonvx,IssmPDouble* xyz_list, GaussPenta* gauss){_error_("not implemented yet");};
		void GetVyStrainRate3dPattyn(IssmPDouble* epsilonvy,IssmPDouble* xyz_list, GaussPenta* gauss){_error_("not implemented yet");};
		void ChangeEnum(int newenumtype){_error_("not implemented yet");};
		void SquareMin(IssmPDouble* psquaremin, bool process_units,Parameters* parameters){_error_("not implemented yet");};
		void ConstrainMin(IssmPDouble minimum){_error_("not implemented yet");};
		void Scale(IssmPDouble scale_factor){_error_("not implemented yet");};
		void ArtificialNoise(IssmPDouble min,IssmPDouble max){_error_("not implemented yet");};
		void AXPY(Input* xinput,IssmPDouble scalar){_error_("not implemented yet");};
		void Constrain(void);
		void Constrain(IssmPDouble min,IssmPDouble max);
		IssmPDouble InfinityNorm(void){_error_("not implemented yet");};
		IssmPDouble Max(void){_error_("not implemented yet");};
		IssmPDouble MaxAbs(void){_error_("not implemented yet");};
		IssmPDouble Min(void){_error_("not implemented yet");};
		IssmPDouble MinAbs(void){_error_("not implemented yet");};
		void Extrude(void);
		void VerticallyIntegrate(Input* thickness_input);
		void GetVectorFromInputs(Vector* vector,int* doflist,const char* data);
		void GetVectorFromInputs(Vector* vector,int* doflist);
		void GetValuesPtr(IssmPDouble** pvalues,int* pnum_values){_error_("not implemented yet");};
		ElementResult* SpawnGradient(int step, IssmPDouble time);
		void GetGradient(Vector* gradient_vec,int* doflist);
		void ScaleGradient(IssmPDouble scale);
		void SetGradient(Input* gradient_in);
		void UpdateValue(IssmPDouble scalar);
		void SaveValue(void);
		/*}}}*/

};
#endif  /* _CONTROLINPUT_H */
