/*!\file: Observations.h
 * \brief prototypes for Observations.h
 */ 

#ifndef _CONTAINER_OBSERVATIONS_H_
#define  _CONTAINER_OBSERVATIONS_H_

class Obsevration;
class Quadtree;
class Variogram;
class Options;

class Observations: public DataSet{

	private:
		Quadtree* quadtree;

	public:

		/*constructors, destructors*/
		Observations();
		Observations(double* observations_list,double* x,double* y,int n,Options* options);
		~Observations();

		/*Methods*/
		void ClosestObservation(double *px,double *py,double *pobs,double x_interp,double y_interp,double radius);
		void InterpolationKriging(double *pprediction,double *perror,double x_interp,double y_interp,double radius,int mindata,int maxdata,Variogram* variogram);
		void ObservationList(double **px,double **py,double **pobs,int* pnobs);
		void ObservationList(double **px,double **py,double **pobs,int* pnobs,double x_interp,double y_interp,double radius,int maxdata);
		void QuadtreeColoring(double* A,double *x,double *y,int n);
		void Variomap(double* gamma,double *x,int n);

};
#endif //ifndef _OBSERVATIONS_H_

