function plotmodel(md,varargin)
%At command prompt, type plotdoc for help on documentation.

%First process options
options=plotoptions(varargin{:});

%get number of subplots
subplotwidth=ceil(sqrt(options.numberofplots));

%if nlines and ncols specified, then bypass.
if exist(options.list{1},'nlines'),
	nlines=getfieldvalue(options.list{1},'nlines');
else 
	nlines=subplotwidth;
end

if exist(options.list{1},'ncols'),
	ncols=getfieldvalue(options.list{1},'ncols');
else 
	ncols=subplotwidth;
end

%check that nlines and ncols were given at the same time!
if ((exist(options.list{1},'ncols') & ~exist(options.list{1},'ncols')) | (~exist(options.list{1},'ncols') & exist(options.list{1},'ncols')))
	error('plotmodel error message: nlines and ncols  need to be specified together, or not at all');
end

%Get figure number and number of plots
figurenumber=options.figurenumber;
numberofplots=options.numberofplots;

%go through subplots
if numberofplots,
		
	%Create figure 
	if strcmpi(getfieldvalue(options.list{1},'visible','on'),'off'),
		F=figure(figurenumber);clf;
		set(F,'Visible','Off');
	else
		figure(figurenumber);clf;
	end

	%Use zbuffer renderer (snoother colors)
	set(gcf,'Renderer','zbuffer');

	%Go through all data plottable and close window if an error occurs
	try,
		for i=1:numberofplots,
			plot_manager(getfieldvalue(options.list{i},'model',md),options.list{i},subplotwidth,nlines,ncols,i);

		end
	catch me,
		%figure(figurenumber),close;
		rethrow(me);
	end
else
	error('plotmodel error message: no output data found. ');
end
