function [B E]=pkriging(x,y,observations,x_interp,y_interp,varargin);
%PKRIGING - parallel Kriging
%
%   Usage:
%      [B E]=pkriging(x,y,observations,x_interp,y_interp,varargin);

options=pairoptions(varargin{:});
cluster=getfieldvalue(options,'cluster',generic('np',10));
name   = 'krig';

% =========================================   MARSHALL.m =================================================
disp(['marshalling file ' name '.bin']);
fid=fopen([name '.bin'],'wb');
if fid==-1,
	error(['marshall error message: could not open ' name '.bin file for binary writing']);
end

%First, write MaximumNumberOfEnum to make sure that the Enums are synchronized
WriteData(fid,'enum',MaximumNumberOfEnums(),'data',true,'format','Boolean');

%Write all data
WriteData(fid,'enum',0,'data',x,'format','DoubleMat');
WriteData(fid,'enum',1,'data',y,'format','DoubleMat');
WriteData(fid,'enum',2,'data',observations,'format','DoubleMat');
WriteData(fid,'enum',3,'data',x_interp,'format','DoubleMat');
WriteData(fid,'enum',4,'data',y_interp,'format','DoubleMat');
options.marshall(fid);
st=fclose(fid);
if st==-1,
	error(['marshall error message: could not close file ' name '.bin']);
end
% =========================================   MARSHALL.m =================================================

%Launch job on remote cluster
BuildKrigingQueueScript(cluster,name,'',1,0,0); %gather, valgrind, gprof
LaunchQueueJob(cluster,name,name,{[name '.bin'] [name '.queue']});
Download(cluster,name,{[name '.outbin']});

%Process results
structure=parseresultsfromdisk([name '.outbin'],0);
B=structure.AutodiffForward(1:length(structure.AutodiffForward)/2);
B=reshape(B,size(x_interp,1),size(x_interp,2));
E=structure.AutodiffForward(length(structure.AutodiffForward)/2+1:end);
E=reshape(E,size(x_interp,1),size(x_interp,2));
