function plot_profile(md,data,options,nlines,ncols,i)
%PLOT_SECTION - plot a given field on a profile
%
%   Usage:
%      plot_profile(md,data,options,nlines,ncols,i)
%
%   See also: PLOTMODEL

%process model
[x_m y_m z_m elements_m is2d isplanet]=processmesh(md,[],options);
if ~is2d, error('only 3d model supported'); end

%Get number of curves and generate random colors
numcurves=size(data,2);
colorm=getfieldvalue(options,'colormap','lines');
color=eval([ colorm '(numcurves);']);
options=removefield(options,'colormap',0); %back to default colormap

%Loop over number of curves
for i=1:numcurves,

	%Process data
	[datai datatype]=processdata(md,data(:,i),options);

	%resolution
	if exist(options,'resolution'),
		resolution=getfieldvalue(options,'resolution');
	else %Default resolution
		resolution=[100];
		disp(['plot_profile warning: no resolution specified, use default resolution: [horizontal_resolution vertical_resolution]=[' num2str(resolution)  ']']);
	end

	%Compute profile value
	[z,data_interp]=ProfileValues(md,data,xprof,yprof,resolution)

	%plot profile
	subplot(nlines,ncols,i)
	A=elements(:,1); B=elements(:,2); C=elements(:,3);  D=elements(:,4); 
	plot(data_interp,z,'color',color(i,:),'LineWidth',getfieldvalue(options,'linewidth',1));
	hold on;
end

%apply options
options=addfielddefault(options,'title','Profile');
options=addfielddefault(options,'colorbar',0);
options=addfielddefault(options,'ylabel','z');
applyoptions(md,[],options);
