function [sx,sy,s]=slope(md)
%SLOPE - compute the surface slope
%
%   Usage:
%      [sx,sy,s]=slope(md)

%load some variables (it is much faster if the variab;es are loaded from md once for all) 
if strcmpi(md.type,'2d'),
	numberofelements=md.numberofelements;
	numberofgrids=md.numberofgrids;
	index=md.elements;
	x=md.x; y=md.y; z=md.z;
else
	numberofelements=md.numberofelements2d;
	numberofgrids=md.numberofgrids2d;
	index=md.elements2d;
	x=md.x2d; y=md.y2d; z=md.z2d;
end

%compute nodal functions coefficients N(x,y)=alpha x + beta y + gamma
[alpha beta]=GetNodalFunctionsCoeff(index,x,y);

summation=[1;1;1];
sx=(md.surface(index).*alpha)*summation;
sy=(md.surface(index).*beta)*summation;
s=sqrt(sx.^2+sy.^2);

if strcmpi(md.type,'3d'),
	sx=project3d(md,sx,'element');
	sy=project3d(md,sy,'element');
	s=sqrt(sx.^2+sy.^2);
end
