/*!\file OptionCell.cpp
 * \brief: implementation of the optionscell object
 */

/*Headers:*/
/*{{{*/
#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include <stdio.h>
#include <string.h>
#include "../objects.h"
#include "../../shared/shared.h"
#include "../../io/io.h"
#include "../../Container/Container.h"
#include "../../include/include.h"
/*}}}*/

/*Constructors/destructor/copy*/
/*FUNCTION OptionCell::OptionCell(){{{*/
OptionCell::OptionCell(){

	values    =NULL;

}
/*}}}*/
/*FUNCTION OptionCell::~OptionCell(){{{*/
OptionCell::~OptionCell(){

	if (values){
		delete values;
		values    =NULL;
	}

}
/*}}}*/

/*Other*/
/*FUNCTION OptionCell::Echo {{{*/
void  OptionCell::Echo(){

	char cstr[81];
	bool flag     = true;

	_printf_(flag,"OptionCell Echo:\n");
	Option::Echo();

	if (values && size) {
		StringFromSize(cstr,size,ndims);
		_printf_(flag,"        values: %s %s\n" ,cstr,"cell");
	}
	else _printf_(flag,"        values: [empty]\n" );
}
/*}}}*/
/*FUNCTION OptionCell::DeepEcho() {{{*/
void  OptionCell::DeepEcho(){

	char  indent[81]="";

	OptionCell::DeepEcho(indent);

	return;
}
/*}}}*/
/*FUNCTION OptionCell::DeepEcho(char* indent) {{{*/
void  OptionCell::DeepEcho(char* indent){

	int   i;
	int*  dims;
	char  indent2[81];
	char  cstr[81];
	bool  flag=true;

	_printf_(flag,"%sOptionCell DeepEcho:\n",indent);
	Option::DeepEcho(indent);

	memcpy(indent2,indent,(strlen(indent)+1)*sizeof(char));
	strcat(indent2,"  ");

	if (values->Size()) {
		dims=(int *) xmalloc(ndims*sizeof(int));
		for (i=0; i<values->Size(); i++) {
			ColumnWiseDimsFromIndex(dims,i,size,ndims);
			StringFromDims(cstr,dims,ndims);
			_printf_(flag,"%s        values: -------- begin %s --------\n" ,indent,cstr);
			((Option *)values->GetObjectByOffset(i))->DeepEcho(indent2);
			_printf_(flag,"%s        values: --------  end  %s --------\n" ,indent,cstr);
		}
		xfree((void**)&dims);
	}
	else _printf_(flag,"%s        values: [empty]\n" ,indent);
}
/*}}}*/
/*FUNCTION OptionCell::Name {{{*/
char* OptionCell::Name(){

	return(Option::Name());
}
/*}}}*/
/*FUNCTION OptionCell::NumEl {{{*/
int   OptionCell::NumEl(){

	return(Option::NumEl());
}
/*}}}*/
/*FUNCTION OptionCell::NDims {{{*/
int   OptionCell::NDims(){

	return(Option::NDims());
}
/*}}}*/
/*FUNCTION OptionCell::Size {{{*/
int*  OptionCell::Size(){

	return(Option::Size());
}
/*}}}*/
/*FUNCTION OptionCell::Get(Options** pvalue) {{{*/
void OptionCell::Get(Options** pvalue){

	/*Assign output pointer*/
	*pvalue=this->values;
}
/*}}}*/
