/*!\file Option.cpp
 * \brief: implementation of the optionsobject abstract object
 */

/*Headers:*/
/*{{{*/
#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include <stdio.h>
#include <string.h>
#include "../objects.h"
#include "../../shared/shared.h"
#include "../../Container/Container.h"
#include "../../io/io.h"
#include "../../include/include.h"
/*}}}*/

/*Constructors/destructor/copy*/
/*FUNCTION Option::Option(){{{*/
Option::Option(){

	name  =NULL;
	numel =0;
	ndims =0;
	size  =NULL;

}
/*}}}*/
/*FUNCTION Option::~Option(){{{*/
Option::~Option(){

	if(size) xfree((void**)&size);
	if(name) xfree((void**)&name);

}
/*}}}*/

/*Other*/
/*FUNCTION Option::Echo {{{*/
void  Option::Echo(){

	char  cstr[81];
	bool  flag=true;

	_printf_(flag,"          name: \"%s\"\n" ,name);
	_printf_(flag,"         numel: %d\n"     ,numel);
	_printf_(flag,"         ndims: %d\n"     ,ndims);
	if(size){
		StringFromSize(cstr,size,ndims);
		_printf_(flag,"          size: %s\n" ,cstr);
	}
	else _printf_(flag,"          size: [empty]\n" );
}
/*}}}*/
/*FUNCTION Option::DeepEcho() {{{*/
void  Option::DeepEcho(){

	char  indent[81]="";

	Option::DeepEcho(indent);

	return;
}
/*}}}*/
/*FUNCTION Option::DeepEcho(char* indent) {{{*/
void  Option::DeepEcho(char* indent){

	char  cstr[81];
	bool  flag=true;

	_printf_(flag,"%s          name: \"%s\"\n" ,indent,name);
	_printf_(flag,"%s         numel: %d\n"     ,indent,numel);
	_printf_(flag,"%s         ndims: %d\n"     ,indent,ndims);
	if(size){
		StringFromSize(cstr,size,ndims);
		_printf_(flag,"%s          size: %s\n" ,indent,cstr);
	}
	else _printf_(flag,"%s          size: [empty]\n" ,indent);
}
/*}}}*/
/*FUNCTION Option::Name {{{*/
char* Option::Name(){

	return(name);
}
/*}}}*/
/*FUNCTION Option::NumEl {{{*/
int   Option::NumEl(){

	return(numel);
}
/*}}}*/
/*FUNCTION Option::NDims {{{*/
int   Option::NDims(){

	return(ndims);
}
/*}}}*/
/*FUNCTION Option::Size {{{*/
int*  Option::Size(){

	return(size);
}
/*}}}*/
/*FUNCTION Option::Get {{{*/
//void* Option::Get(){

//	;

//	return;
//}
/*}}}*/
