/*!\file Hook.h
 * \brief: header file for hook object.
 * A hook is a class  that can store the id, offset, and object corresponding to this id and offset into a dataset.
 * For example, an element has a hook to its nodes. A node has a hook to its vertex.  The hook abstracts the need for having
 * ids and offsets (necesarry for proper configuration of an object) in our objects. 
 */

#ifndef _HOOK_H_
#define _HOOK_H_

/*Headers:*/
/*{{{*/
#include "./Object.h"
class DataSet;
/*}}}*/

class Hook{

	private: 

		int	   num; //number of objects being hooked onto
		Object**	   objects; //list of object pointers. we do not allocate objects, just a list a pointers, that will get to point to the real objects from a dataset.
		int*   ids;     //list of object ids, to go look for them in datasets.
		int*   offsets;  //list of object offsets into datasets, to speed up lookup.

	public:

		/*Hook constructors, destructors: {{{*/
		Hook();
		Hook(int* ids, int num);
		~Hook();
		/*}}}*/
		/*Object like functionality:{{{*/
		void       Echo(void);
		void       DeepEcho(void);
		Object*    copy(void);
		/*}}}*/
		/*Hook management: {{{*/
		Object*    delivers(void); //single object deliver
		Object**   deliverp(void); //deliver all objects
		void       configure(DataSet* dataset);
		Hook*      Spawn(int* indices, int numindices);
		Object**   GetObjects(void);
		int*       Ids(void);
		int*       GetOffsets(void);
		int        GetNum(void);
		/*}}}*/
};

#endif  /* _HOOK_H_ */
