/*!\file TriaP1ElementResult.c
 * \brief: implementation of the TriaP1ElementResult object
 */

#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include <stdio.h>
#include <string.h>
#include "./ElementResultLocal.h"
#include "../objects.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../shared/shared.h"
#include "../../Container/Container.h"
#include "../../include/include.h"

/*TriaP1ElementResult constructors and destructor*/
/*FUNCTION TriaP1ElementResult::TriaP1ElementResult(){{{*/
TriaP1ElementResult::TriaP1ElementResult(){
	return;
}
/*}}}*/
/*FUNCTION TriaP1ElementResult::TriaP1ElementResult(int in_enum_type,double* in_values,int in_step, double in_time){{{*/
TriaP1ElementResult::TriaP1ElementResult(int in_enum_type,double* in_values,int in_step, double in_time){

	enum_type=in_enum_type;
	values[0]=in_values[0];
	values[1]=in_values[1];
	values[2]=in_values[2];
	step=in_step;
	time=in_time;
}
/*}}}*/
/*FUNCTION TriaP1ElementResult::~TriaP1ElementResult(){{{*/
TriaP1ElementResult::~TriaP1ElementResult(){
	return;
}
/*}}}*/

/*Object virtual functions definitions:*/
/*FUNCTION TriaP1ElementResult::Echo {{{*/
void TriaP1ElementResult::Echo(void){
	this->DeepEcho();
}
/*}}}*/
/*FUNCTION TriaP1ElementResult::DeepEcho{{{*/
void TriaP1ElementResult::DeepEcho(void){
		
	printf("TriaP1ElementResult:\n");
	printf("   enum: %i (%s)\n",this->enum_type,EnumToStringx(this->enum_type));
	printf("   values: [%g %g %g]\n",this->values[0],this->values[1],this->values[2]);
	printf("   step: %i\n",this->step);
	printf("   time: %g\n",this->time);
}
/*}}}*/
/*FUNCTION TriaP1ElementResult::Id{{{*/
int    TriaP1ElementResult::Id(void){ return -1; }
/*}}}*/
/*FUNCTION TriaP1ElementResult::MyRank{{{*/
int    TriaP1ElementResult::MyRank(void){ 
	extern int my_rank;
	return my_rank; 
}
/*}}}*/
/*FUNCTION TriaP1ElementResult::ObjectEnum{{{*/
int TriaP1ElementResult::ObjectEnum(void){

	return TriaP1ElementResultEnum;

}
/*}}}*/
/*FUNCTION TriaP1ElementResult::copy{{{*/
Object* TriaP1ElementResult::copy() {
	
	return new TriaP1ElementResult(this->enum_type,this->values,this->step,this->time);

}
/*}}}*/

/*ElementResult management*/
/*FUNCTION TriaP1ElementResult::InstanceEnum{{{*/
int TriaP1ElementResult::InstanceEnum(void){

	return this->enum_type;

}
/*}}}*/
/*FUNCTION TriaP1ElementResult::SpawnTriaElementResult{{{*/
ElementResult* TriaP1ElementResult::SpawnTriaElementResult(int* indices){

	/*output*/
	TriaP1ElementResult* outresult=NULL;

	/*Create new Tria result (copy of current result)*/
	outresult=new TriaP1ElementResult(this->enum_type,&this->values[0],this->step,this->time);

	/*Assign output*/
	return outresult;

}
/*}}}*/
/*FUNCTION TriaP1ElementResult::ProcessUnits{{{*/
void TriaP1ElementResult::ProcessUnits(Parameters* parameters){
	
	UnitConversion(this->values,3,IuToExtEnum,this->enum_type);

}
/*}}}*/
/*FUNCTION TriaP1ElementResult::NumberOfNodalValues{{{*/
int TriaP1ElementResult::NumberOfNodalValues(void){
	return 3;
}
/*}}}*/
/*FUNCTION TriaP1ElementResult::PatchFill{{{*/
void TriaP1ElementResult::PatchFill(int row, Patch* patch){
	
	 /*Here, we fill the result information into the patch object. First, let's remember what is in a row 
	  * of the patch object: enum_type step time element_id interpolation vertices_ids nodal_values
	  * Here, we will supply the enum_type, step, time, interpolation and nodal_values: */
	patch->fillresultinfo(row,this->enum_type,this->step,this->time,P1Enum,this->values,3);

}
/*}}}*/
/*FUNCTION TriaP1ElementResult::GetVectorFromResults{{{*/
void TriaP1ElementResult::GetVectorFromResults(Vector* vector,int* doflist,int* connectivitylist,int numdofs){

	double data[3];

	if(numdofs!=3)_error_("Result %s is a TriaP1ElementResult and cannot write vector of %i dofs",numdofs);
	for(int i=0;i<3;i++) data[i]=this->values[i]/(double)connectivitylist[i];
	vector->SetValues(numdofs,doflist,&data[0],ADD_VAL);

} /*}}}*/
/*FUNCTION TriaP1ElementResult::GetElementVectorFromResults{{{*/
void TriaP1ElementResult::GetElementVectorFromResults(Vector* vector,int dof){
	_error_("Result %s is a TriaP1ElementResult and should not write vector of size numberofelemenrs",EnumToStringx(enum_type));
} /*}}}*/
