/*!\file BoolElementResult.c
 * \brief: implementation of the BoolElementResult object
 */

#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include <stdio.h>
#include <string.h>
#include "./ElementResultLocal.h"
#include "../objects.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../shared/shared.h"
#include "../../Container/Container.h"
#include "../../include/include.h"

/*BoolElementResult constructors and destructor*/
/*FUNCTION BoolElementResult::BoolElementResult(){{{*/
BoolElementResult::BoolElementResult(){
	return;
}
/*}}}*/
/*FUNCTION BoolElementResult::BoolElementResult(int in_enum_type,IssmDouble in_value,int in_step, double in_time){{{*/
BoolElementResult::BoolElementResult(int in_enum_type,bool in_value,int in_step, double in_time){

	enum_type=in_enum_type;
	value=in_value;
	step=in_step;
	time=in_time;
}
/*}}}*/
/*FUNCTION BoolElementResult::~BoolElementResult(){{{*/
BoolElementResult::~BoolElementResult(){
	return;
}
/*}}}*/

/*Object virtual functions definitions:*/
/*FUNCTION BoolElementResult::Echo {{{*/
void BoolElementResult::Echo(void){
	this->DeepEcho();
}
/*}}}*/
/*FUNCTION BoolElementResult::DeepEcho{{{*/
void BoolElementResult::DeepEcho(void){

	printf("BoolElementResult:\n");
	printf("   enum: %i (%s)\n",this->enum_type,EnumToStringx(this->enum_type));
	printf("   value: %s\n",this->value?"true":"false");
	printf("   step: %i\n",this->step);
	printf("   time: %g\n",this->time);
}
/*}}}*/
/*FUNCTION BoolElementResult::Id{{{*/
int    BoolElementResult::Id(void){ return -1; }
/*}}}*/
/*FUNCTION BoolElementResult::MyRank{{{*/
int    BoolElementResult::MyRank(void){ 
	extern int my_rank;
	return my_rank; 
}
/*}}}*/
/*FUNCTION BoolElementResult::ObjectEnum{{{*/
int BoolElementResult::ObjectEnum(void){

	return BoolElementResultEnum;

}
/*}}}*/
/*FUNCTION BoolElementResult::copy{{{*/
Object* BoolElementResult::copy() {

	return new BoolElementResult(this->enum_type,this->value,this->step,this->time);

}
/*}}}*/

/*ElementResult management*/
/*FUNCTION BoolElementResult::InstanceEnum{{{*/
int BoolElementResult::InstanceEnum(void){

	return this->enum_type;

}
/*}}}*/
/*FUNCTION BoolElementResult::SpawnTriaElementResult{{{*/
ElementResult* BoolElementResult::SpawnTriaElementResult(int* indices){

	/*output*/
	BoolElementResult* outresult=new BoolElementResult();

	/*copy fields: */
	outresult->enum_type=this->enum_type;
	outresult->value=this->value;
	outresult->time=this->time;
	outresult->step=this->step;

	/*Assign output*/
	return outresult;

}
/*}}}*/
/*FUNCTION BoolElementResult::ProcessUnits{{{*/
void BoolElementResult::ProcessUnits(Parameters* parameters){
	
	this->value=UnitConversion(this->value,IuToExtEnum,this->enum_type);

}
/*}}}*/
/*FUNCTION BoolElementResult::NumberOfNodalValues{{{*/
int BoolElementResult::NumberOfNodalValues(void){
	return 1;
}
/*}}}*/
/*FUNCTION BoolElementResult::PatchFill{{{*/
void BoolElementResult::PatchFill(int row, Patch* patch){
	
	 /*Here, we fill the result information into the patch object. First, let's remember what is in a row 
	  * of the patch object: enum_type step time element_id interpolation vertices_ids nodal_values
	  * Here, we will supply the enum_type, step, time, interpolation and nodal_values: */
	double doublevalue=this->value?1:0;
	patch->fillresultinfo(row,this->enum_type,this->step,this->time,P0Enum,&doublevalue,1);

}
/*}}}*/
/*FUNCTION BoolElementResult::GetVectorFromResults{{{*/
void BoolElementResult::GetVectorFromResults(Vector* vector,int* doflist,int* connectivitylist,int numdofs){

	_error_("cannot return vector on vertices");
} /*}}}*/
/*FUNCTION BoolElementResult::GetElementVectorFromResults{{{*/
void BoolElementResult::GetElementVectorFromResults(Vector* vector,int dof){

	vector->SetValue(dof,value,INS_VAL);
} /*}}}*/
