/*!\file Penpair.h
 * \brief: header file for penpair object */

#ifndef _PENPAIR_H_
#define _PENPAIR_H_

/*Headers:*/
/*{{{*/
#include "./Load.h"
#include "../Node.h"
#include "../Elements/Element.h"

class Element;
/*}}}*/

class Penpair: public Load{

	private: 
		int		id;
		int analysis_type;
		
		Hook* hnodes;  //hook to 2 nodes
		Node** nodes;

		Parameters* parameters; //pointer to solution parameters

	public:

		/*Penpair constructors, destructors: {{{*/
		Penpair();
		Penpair(int penpair_id,int* penpair_node_ids,int analysis_type);
		~Penpair();
		/*}}}*/
		/*Object virtual functions definitions:{{{ */
		void  Echo();
		void  DeepEcho();
		int   Id(); 
		int   MyRank();
		int   ObjectEnum();
		Object* copy();
		/*}}}*/
		/*Update virtual functions resolution: {{{*/
		void  InputUpdateFromVector(double* vector, int name, int type);
		void  InputUpdateFromVector(int* vector, int name, int type);
		void  InputUpdateFromVector(bool* vector, int name, int type);
		void  InputUpdateFromMatrixDakota(double* matrix, int nrow, int ncols,int name, int type){_error_("Not implemented yet!");}
		void  InputUpdateFromVectorDakota(double* vector, int name, int type){_error_("Not implemented yet!");}
		void  InputUpdateFromVectorDakota(int* vector, int name, int type){_error_("Not implemented yet!");}
		void  InputUpdateFromVectorDakota(bool* vector, int name, int type){_error_("Not implemented yet!");}
		void  InputUpdateFromConstant(double constant, int name);
		void  InputUpdateFromConstant(int constant, int name);
		void  InputUpdateFromConstant(bool constant, int name);
		void  InputUpdateFromSolution(double* solution){_error_("Not implemented yet!");}
		void  InputUpdateFromIoModel(int index, IoModel* iomodel){_error_("not implemented yet");};
		/*}}}*/
			/*Load virtual functions definitions: {{{*/
		void  Configure(Elements* elements,Loads* loads,Nodes* nodes,Vertices* vertices,Materials* materials,Parameters* parameters);
		void  SetCurrentConfiguration(Elements* elements,Loads* loads,Nodes* nodes,Vertices* vertices,Materials* materials,Parameters* parameters);
		void  CreateKMatrix(Matrix* Kff, Matrix* Kfs);
		void  CreatePVector(Vector* pf);
		void  CreateJacobianMatrix(Matrix* Jff);
		void  PenaltyCreateKMatrix(Matrix* Kff,Matrix* Kfs,double kmax);
		void  PenaltyCreatePVector(Vector* pf, double kmax);
		void  PenaltyCreateJacobianMatrix(Matrix* Jff,double kmax);
		bool  InAnalysis(int analysis_type);
		/*}}}*/
			/*Penpair management: {{{*/
		ElementMatrix* PenaltyCreateKMatrixDiagnosticHoriz(double kmax);
		ElementMatrix* PenaltyCreateKMatrixDiagnosticMacAyealPattyn(double kmax);
		ElementMatrix* PenaltyCreateKMatrixDiagnosticStokes(double kmax);
		ElementMatrix* PenaltyCreateKMatrixPrognostic(double kmax);
		/*}}}*/
};

#endif  /* _PENPAIR_H_ */


