/*!\file Pengrid.h
 * \brief: header file for pengrid object */

#ifndef _PENGRID_H_
#define _PENGRID_H_

/*Headers:*/
/*{{{*/
#include "./Load.h"
class Hook;
class Inputs;
class Parameters;
class IoModel;
/*}}}*/

class Pengrid: public Load{

	private: 

		int		id;
		int analysis_type;
		
		/*Hooks*/
		Hook* hnode;  //hook to 1 node
		Hook* helement;  //hook to 1 element
		Hook* hmatpar; //hook to 1 matpar

		/*Corresponding fields*/
		Node    *node;
		Element *element;
		Matpar  *matpar;

		Parameters* parameters; //pointer to solution parameters
		Inputs*  inputs;
	
		/*internals: */
		int active;
		int zigzag_counter;

	public:

		/*Pengrid constructors, destructors {{{*/
		Pengrid();
		Pengrid(int index, int id, IoModel* iomodel,int analysis_type);
		~Pengrid();
		/*}}}*/
		/*Object virtual functions definitions:{{{ */
		void  Echo();
		void  DeepEcho();
		int   Id(); 
		int   MyRank();
		int   ObjectEnum();
		Object* copy();
		/*}}}*/
		/*Update virtual functions resolution: {{{*/
		void  InputUpdateFromVector(double* vector, int name, int type);
		void  InputUpdateFromVector(int* vector, int name, int type);
		void  InputUpdateFromVector(bool* vector, int name, int type);
		void  InputUpdateFromMatrixDakota(double* matrix ,int nrows, int ncols, int name, int type);
		void  InputUpdateFromVectorDakota(double* vector, int name, int type);
		void  InputUpdateFromVectorDakota(int* vector, int name, int type);
		void  InputUpdateFromVectorDakota(bool* vector, int name, int type);
		void  InputUpdateFromConstant(double constant, int name);
		void  InputUpdateFromConstant(int constant, int name);
		void  InputUpdateFromConstant(bool constant, int name);
		void  InputUpdateFromSolution(double* solution);
		void  InputUpdateFromIoModel(int index, IoModel* iomodel){_error_("not implemented yet");};
		/*}}}*/
		/*Load virtual functions definitions: {{{*/
		void  Configure(Elements* elements,Loads* loads,Nodes* nodes,Vertices* vertices,Materials* materials,Parameters* parameters);
		void  SetCurrentConfiguration(Elements* elements,Loads* loads,Nodes* nodes,Vertices* vertices,Materials* materials,Parameters* parameters);
		void  CreateKMatrix(Matrix* Kff, Matrix* Kfs);
		void  CreatePVector(Vector* pf);
		void  CreateJacobianMatrix(Matrix* Jff){_error_("Not implemented yet");};
		void  PenaltyCreateJacobianMatrix(Matrix* Jff,double kmax){_error_("Not implemented yet");};
		void  PenaltyCreateKMatrix(Matrix* Kff, Matrix* kfs, double kmax);
		void  PenaltyCreatePVector(Vector* pf, double kmax);
		bool  InAnalysis(int analysis_type);
		/*}}}*/
		/*Pengrid management {{{*/
		#ifdef _HAVE_DIAGNOSTIC_
		ElementMatrix* PenaltyCreateKMatrixDiagnosticStokes(double kmax);
		#endif
		#ifdef _HAVE_THERMAL_
		ElementMatrix* PenaltyCreateKMatrixThermal(double kmax);
		ElementMatrix* PenaltyCreateKMatrixMelting(double kmax);
		ElementVector* PenaltyCreatePVectorThermal(double kmax);
		ElementVector* PenaltyCreatePVectorMelting(double kmax);
		#endif
		void  ConstraintActivate(int* punstable);
		void  ConstraintActivateThermal(int* punstable);
		void  UpdateInputs(double* solution);
		void  ResetConstraint(void);
		/*}}}*/

};

#endif  /* _PENGRID_H_ */


