/*! \file DatasetInput.h 
 *  \brief: header file for datasetinput object
 */


#ifndef _DATASETINPUT_H_
#define _DATASETINPUT_H_

/*Headers:*/
/*{{{*/
#include "./Input.h"
#include "../../include/include.h"
class GaussTria;
/*}}}*/

class DatasetInput: public Input{

	public:
		int    enum_type;

		Inputs*     inputs;

		/*DatasetInput constructors, destructors: {{{*/
		DatasetInput();
		DatasetInput(int enum_type);
		~DatasetInput();
		/*}}}*/
		/*Object virtual functions definitions:{{{ */
		void  Echo();
		void  DeepEcho();
		int   Id();
		int   MyRank();
		int   ObjectEnum();
		Object* copy();
		/*}}}*/
		/*DatasetInput management: {{{*/
		int    InstanceEnum();
		Input* SpawnTriaInput(int* indices);
		Input* PointwiseDivide(Input* inputB){_error_("not implemented yet");};
		Input* PointwiseMin(Input* inputB){_error_("not implemented yet");};
		Input* PointwiseMax(Input* inputB){_error_("not implemented yet");};
		ElementResult* SpawnResult(int step, double time){_error_("not implemented yet");};
		void AddTimeValues(double* values,int step,double time){_error_("not supported yet");};
		void Configure(Parameters* parameters);
		/*}}}*/
		/*numeriics: {{{*/
		void GetInputValue(bool* pvalue){_error_("not implemented yet");};
		void GetInputValue(int* pvalue){_error_("not implemented yet");};
		void GetInputValue(double* pvalue){_error_("not implemented yet");};
		void GetInputValue(double* pvalue,GaussTria* gauss){_error_("not implemented yet");};
		void GetInputValue(double* pvalue,GaussTria* gauss,double time){_error_("not implemented yet");};
		void GetInputValue(double* pvalue,GaussPenta* gauss){_error_("not implemented yet");};
		void GetInputValue(double* pvalue,GaussTria* gauss ,int index);
		void GetInputValue(double* pvalue,GaussPenta* gauss ,int index){_error_("not implemented yet");};
		void GetInputDerivativeValue(double* derivativevalues, double* xyz_list, GaussTria* gauss){_error_("not implemented yet");};
		void GetInputDerivativeValue(double* derivativevalues, double* xyz_list, GaussPenta* gauss){_error_("not implemented yet");};
		void GetInputAverage(double* pvalue){_error_("not implemented yet");};
		void GetVxStrainRate2d(double* epsilonvx,double* xyz_list, GaussTria* gauss){_error_("not implemented yet");};
		void GetVyStrainRate2d(double* epsilonvy,double* xyz_list, GaussTria* gauss){_error_("not implemented yet");};
		void GetVxStrainRate3d(double* epsilonvx,double* xyz_list, GaussPenta* gauss){_error_("not implemented yet");};
		void GetVyStrainRate3d(double* epsilonvy,double* xyz_list, GaussPenta* gauss){_error_("not implemented yet");};
		void GetVzStrainRate3d(double* epsilonvz,double* xyz_list, GaussPenta* gauss){_error_("not implemented yet");};
		void GetVxStrainRate3dPattyn(double* epsilonvx,double* xyz_list, GaussPenta* gauss){_error_("not implemented yet");};
		void GetVyStrainRate3dPattyn(double* epsilonvy,double* xyz_list, GaussPenta* gauss){_error_("not implemented yet");};
		void ChangeEnum(int newenumtype){_error_("not implemented yet");};
		void SquareMin(double* psquaremin, bool process_units,Parameters* parameters){_error_("not implemented yet");};
		void ConstrainMin(double minimum){_error_("not implemented yet");};
		void Scale(double scale_factor){_error_("not implemented yet");};
		void ArtificialNoise(double min,double max){_error_("not implemented yet");};
		void AXPY(Input* xinput,double scalar){_error_("not implemented yet");};
		void Constrain(void){_error_("not implemented yet");};
		void Constrain(double min,double max){_error_("not implemented yet");};
		double InfinityNorm(void){_error_("not implemented yet");};
		double Max(void){_error_("not implemented yet");};
		double MaxAbs(void){_error_("not implemented yet");};
		double Min(void){_error_("not implemented yet");};
		double MinAbs(void){_error_("not implemented yet");};
		void Extrude(void){_error_("not implemented yet");};
		void VerticallyIntegrate(Input* thickness_input){_error_("not implemented yet");};
		void GetVectorFromInputs(Vector* vector,int* doflist){_error_("not implemented yet");};
		void GetValuesPtr(double** pvalues,int* pnum_values){_error_("not implemented yet");};
		ElementResult* SpawnGradient(int step, double time){_error_("not implemented yet");};
		void GetGradient(Vector* gradient_vec,int* doflist){_error_("not implemented yet");};
		void ScaleGradient(double scale){_error_("not implemented yet");};
		void SetGradient(Input* gradient_in){_error_("not implemented yet");};
		void UpdateValue(double scalar){_error_("not implemented yet");};
		void SaveValue(void){_error_("not implemented yet");};
		/*}}}*/

};
#endif  /* _DATASETINPUT_H */
