/*! \file PetscVecExternalResult.h 
 *  \brief: header file for triavertexinput object
 */


#ifndef _PETSCVECEXTERNALRESULT_H_
#define _PETSCVECEXTERNALRESULT_H_

/*Headers:*/
/*{{{*/

#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "./ExternalResult.h"
#include "../../include/include.h"
#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../include/include.h"
/*}}}*/

class PetscVecExternalResult: public ExternalResult{

	private: 
		int id;
		int enum_type;
		Vector* value;
		int step;
		double time;

	public:
		/*PetscVecExternalResult constructors, destructors: {{{*/
		PetscVecExternalResult();
		PetscVecExternalResult(int id,int enum_type,Vector* value, int step, double time);
		~PetscVecExternalResult();
		/*}}}*/
		/*Object virtual functions definitions:{{{ */
		void  Echo();
		void  DeepEcho();
		int   Id(); 
		int   MyRank();
		int   ObjectEnum();
		Object* copy();
		/*}}}*/
		/*ExternalResult management: {{{*/
		int   InstanceEnum(){return enum_type;}
		void  WriteData(FILE* fid,bool io_gather);
		void  GetResultName(char**);
		int   GetStep(void);
		/*}}}*/
};
#endif  /* _PETSCVECEXTERNALRESULT_H */
