/*!\file DoubleElementResult.c
 * \brief: implementation of the DoubleElementResult object
 */

#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include <stdio.h>
#include <string.h>
#include "./ElementResultLocal.h"
#include "../objects.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../shared/shared.h"
#include "../../Container/Container.h"
#include "../../include/include.h"

/*DoubleElementResult constructors and destructor*/
/*FUNCTION DoubleElementResult::DoubleElementResult(){{{*/
DoubleElementResult::DoubleElementResult(){
	return;
}
/*}}}*/
/*FUNCTION DoubleElementResult::DoubleElementResult(int in_enum_type,IssmDouble in_value,int in_step, double in_time){{{*/
DoubleElementResult::DoubleElementResult(int in_enum_type,IssmDouble in_value,int in_step, double in_time){

	enum_type=in_enum_type;
	value=in_value;
	step=in_step;
	time=in_time;
}
/*}}}*/
/*FUNCTION DoubleElementResult::~DoubleElementResult(){{{*/
DoubleElementResult::~DoubleElementResult(){
	return;
}
/*}}}*/

/*Object virtual functions definitions:*/
/*FUNCTION DoubleElementResult::Echo {{{*/
void DoubleElementResult::Echo(void){
	this->DeepEcho();
}
/*}}}*/
/*FUNCTION DoubleElementResult::DeepEcho{{{*/
void DoubleElementResult::DeepEcho(void){

	printf("DoubleElementResult:\n");
	printf("   enum: %i (%s)\n",this->enum_type,EnumToStringx(this->enum_type));
	printf("   value: %g\n",this->value);
	printf("   step: %i\n",this->step);
	printf("   time: %g\n",this->time);
}
/*}}}*/
/*FUNCTION DoubleElementResult::Id{{{*/
int    DoubleElementResult::Id(void){ return -1; }
/*}}}*/
/*FUNCTION DoubleElementResult::MyRank{{{*/
int    DoubleElementResult::MyRank(void){ 
	extern int my_rank;
	return my_rank; 
}
/*}}}*/
/*FUNCTION DoubleElementResult::ObjectEnum{{{*/
int DoubleElementResult::ObjectEnum(void){

	return DoubleElementResultEnum;

}
/*}}}*/
/*FUNCTION DoubleElementResult::copy{{{*/
Object* DoubleElementResult::copy() {

	return new DoubleElementResult(this->enum_type,this->value,this->step,this->time);

}
/*}}}*/

/*ElementResult management*/
/*FUNCTION DoubleElementResult::InstanceEnum{{{*/
int DoubleElementResult::InstanceEnum(void){

	return this->enum_type;

}
/*}}}*/
/*FUNCTION DoubleElementResult::SpawnTriaElementResult{{{*/
ElementResult* DoubleElementResult::SpawnTriaElementResult(int* indices){

	/*output*/
	DoubleElementResult* outresult=new DoubleElementResult();

	/*copy fields: */
	outresult->enum_type=this->enum_type;
	outresult->value=this->value;
	outresult->time=this->time;
	outresult->step=this->step;

	/*Assign output*/
	return outresult;

}
/*}}}*/
/*FUNCTION DoubleElementResult::ProcessUnits{{{*/
void DoubleElementResult::ProcessUnits(Parameters* parameters){
	
	this->value=UnitConversion(this->value,IuToExtEnum,this->enum_type);

}
/*}}}*/
/*FUNCTION DoubleElementResult::NumberOfNodalValues{{{*/
int DoubleElementResult::NumberOfNodalValues(void){
	return 1;
}
/*}}}*/
/*FUNCTION DoubleElementResult::PatchFill{{{*/
void DoubleElementResult::PatchFill(int row, Patch* patch){
	
	 /*Here, we fill the result information into the patch object. First, let's remember what is in a row 
	  * of the patch object: enum_type step time element_id interpolation vertices_ids nodal_values
	  * Here, we will supply the enum_type, step, time, interpolation and nodal_values: */
	patch->fillresultinfo(row,this->enum_type,this->step,this->time,P0Enum,&this->value,1);

}
/*}}}*/
