/*!\file MatlabMatrixToMatrix.cpp
 */

/*Headers:*/
/*{{{*/
#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include <mex.h>
#include <stdio.h>
#include <string.h>
#include "./matlabio.h"
#include "../../objects/objects.h"
#include "../../shared/shared.h"
#include "../../Container/Container.h"
#include "../../include/include.h"
#include "../../toolkits/toolkits.h"
	
/*}}}*/

Matrix* MatlabMatrixToMatrix(const mxArray* mxmatrix){

	int dummy;
	Matrix* matrix=NULL;

	/*allocate matrix object: */
	matrix=new Matrix();

	#ifdef _HAVE_PETSC_
	MatlabMatrixToPetscMatrix(&matrix->matrix,NULL,NULL,mxmatrix);
	#else
	matrix->matrix=MatlabMatrixToSeqMat(mxmatrix);
	#endif
	
	return matrix;
}
