/* \file matlab macros.h
 * \brief: macros used for the matlab bindings
 */

/*Header {{{*/
#ifndef _MATLAB_MACROS_H_
#define _MATLAB_MACROS_H_

#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif
/*}}}*/

#ifdef _HAVE_MATLAB_
/* MODULEBOOT/MODULEEND {{{*/

/*The following macros hide the error exception handling in a matlab module. Just put 
 * MODULEBOOT(); and MODULEEND(); at the beginning and end of a module, and c++ exceptions 
 * will be trapped. Really nifty!*/
//exception.Report(); 

#define MODULEBOOT(); ModuleBoot(); \
	try{

#define MODULEEND(); ModuleEnd(); }\
	catch(ErrorException &exception){\
		mexErrMsgTxt("ISSM Error"); \
	}\
	catch (exception &e){\
		mexErrMsgTxt(exprintf("Standard exception: %s\n",e.what()));\
	}\
	catch(...){\
		mexErrMsgTxt("An unexpected error occurred");\
	}
//}}}
/* WRAPPER {{{*/
#define WRAPPER(modulename,...) void mexFunction(int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]) 

/*}}}*/
/* CHECKARGUMENTS {{{*/
#define CHECKARGUMENTS(NLHS,NRHS,functionpointer) CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,functionpointer)
/*}}}*/
#endif

#endif
