%PFE class definition
%
%   Usage:
%      cluster=greenplanet();
%      cluster=greenplanet('np',3);
%      cluster=greenplanet('np',3,'login','username');

classdef greenplanet
    properties (SetAccess=public)  
		 % {{{
		 name='greenplanet'
		 login='';
		 numnodes=20;
		 cpuspernode=8; 
		 port=8000;
		 queue='rignot';
		 codepath='';
		 executionpath='';
		 interactive=0;
	 end
	 properties (SetAccess=private) 
		 np=20*8;
		 % }}}
	 end
	 methods
		 function cluster=greenplanet(varargin) % {{{

			 %initialize cluster using default settings if provided
			 if (exist('greenplanet_settings')==2), greenplanet_settings; end

			 %use provided options to change fields
			 cluster=AssignObjectFields(pairoptions(varargin{:}),cluster);
		 end
		 %}}}
		 function disp(cluster) % {{{
			 %  display the object
			 disp(sprintf('class ''%s'' object ''%s'' = ',class(cluster),inputname(1)));
			 disp(sprintf('    name: %s',cluster.name));
			 disp(sprintf('    login: %s',cluster.login));
			 disp(sprintf('    port: %i',cluster.port));
			 disp(sprintf('    numnodes: %i',cluster.numnodes));
			 disp(sprintf('    cpuspernode: %i',cluster.cpuspernode));
			 disp(sprintf('    np: %i',cluster.cpuspernode*cluster.numnodes));
			 disp(sprintf('    queue: %s',cluster.queue));
			 disp(sprintf('    codepath: %s',cluster.codepath));
			 disp(sprintf('    executionpath: %s',cluster.executionpath));
			 disp(sprintf('    interactive: %i',cluster.interactive));
		 end
		 %}}}
		 function checkconsistency(cluster,md,solution,analyses) % {{{

			 available_queues={'rignot','default'};
			 queue_requirements_time=[Inf Inf];
			 queue_requirements_np=[80 80];

			 QueueRequirements(available_queues,queue_requirements_time,queue_requirements_np,cluster.queue,cluster.np,1)

			 %Miscelaneous
			 if isempty(cluster.login), checkmessage('login empty'); end
			 if isempty(cluster.codepath), checkmessage('codepath empty'); end
			 if isempty(cluster.executionpath), checkmessage('executionpath empty'); end

		 end
		 %}}}
		 function BuildQueueScript(cluster,modelname,solution,io_gather,isvalgrind,isgprof) % {{{

			 if(isvalgrind), disp('valgrind not supported by cluster, ignoring...'); end
			 if(isgprof),    disp('gprof not supported by cluster, ignoring...'); end

			 %compute number of processors
			 cluster.np=cluster.numnodes*cluster.cpuspernode;

			 %write queuing script 
			 fid=fopen([modelname '.queue'],'w');
			 fprintf(fid,'#PBS -S /bin/bash\n');
			 fprintf(fid,'#PBS -N %s\n',modelname);
			 fprintf(fid,'#PBS -q %s \n',cluster.queue);
			 fprintf(fid,'#PBS -l nodes=%i:ppn=%i\n',cluster.numnodes,cluster.cpuspernode);
			 fprintf(fid,'#PBS -m bea\n');
			 fprintf(fid,'#PBS -M mmorligh@uci.edu\n');
			 fprintf(fid,'#PBS -o %s.outlog \n',modelname);
			 fprintf(fid,'#PBS -e %s.errlog \n\n',modelname);
			 fprintf(fid,'cd %s/%s\n\n',cluster.executionpath,md.private.runtimename);
			 fprintf(fid,'mpiexec -np %i %s/issm.exe %s %s %s\n',cluster.np,cluster.codepath,EnumToString(solution),cluster.executionpath,modelname);
			 if ~io_gather, %concatenate the output files:
				 fprintf(fid,'cat %s.outbin.* > %s.outbin',modelname,modelname);
			 end
			 fclose(fid);

			 %in interactive mode, create a run file, and errlog and outlog file
			 if cluster.interactive,
				 fid=fopen([modelname '.run'],'w');
				 fprintf(fid,'mpiexec -np %i %s/issm.exe %s %s %s\n',cluster.np,cluster.codepath,EnumToString(solution),cluster.executionpath,modelname);
				 if ~io_gather, %concatenate the output files:
					 fprintf(fid,'cat %s.outbin.* > %s.outbin',modelname,modelname);
				 end
				 fclose(fid);
				 fid=fopen([modelname '.errlog'],'w');
				 fclose(fid);
				 fid=fopen([modelname '.outlog'],'w');
				 fclose(fid);
			 end
		 end %}}}
		 function LaunchQueueJob(cluster,md,options)% {{{
			 
			 %lauch command, to be executed via ssh
			 if ~cluster.interactive, 
				launchcommand=['cd ' cluster.executionpath ' && rm -rf ./' md.private.runtimename ' && mkdir ' md.private.runtimename ...
			                ' && cd ' md.private.runtimename ' && mv ../' md.private.runtimename '.tar.gz ./ && tar -zxf ' md.private.runtimename '.tar.gz  && qsub ' md.miscellaneous.name '.queue '];
			else
				launchcommand=['cd ' cluster.executionpath '/Interactive' num2str(cluster.interactive) ' && tar -zxf ' md.private.runtimename '.tar.gz'];
			end

			if ~strcmpi(options.batch,'yes'),
				
				%compress the files into one zip.
				compressstring=['tar -zcf ' md.private.runtimename '.tar.gz ' md.miscellaneous.name '.bin ' md.miscellaneous.name '.queue '  md.miscellaneous.name '.petsc '];
				if md.qmu.isdakota,
					compressstring=[compressstring md.miscellaneous.name '.qmu.in '];
				end
				if cluster.interactive,
					compressstring=[compressstring md.miscellaneous.name '.run ' md.miscellaneous.name '.errlog ' md.miscellaneous.name '.outlog '];
				end
				system(compressstring);
				
				disp('uploading input file and queueing script');
				if cluster.interactive,
					directory=[cluster.executionpath '/Interactive' num2str(cluster.interactive)];
				else 
					directory=cluster.executionpath;
				end
				
				issmscpout(cluster.name,directory,cluster.login,cluster.port,{[md.private.runtimename '.tar.gz']});
				
				disp('launching solution sequence on remote cluster');
				issmssh(cluster.name,cluster.login,cluster.port,launchcommand);

			else
				disp('batch mode requested: not launching job interactively');
				disp('launch solution sequence on remote cluster by hand');
			end
		 end
		 %}}}
		 function Download(cluster,dirname,filelist)% {{{

			 %copy files from cluster to current directory
			 directory=[cluster.executionpath '/' dirname '/'];
			 issmscpin(cluster.name,cluster.login,cluster.port,directory,filelist);

		 end %}}}
	end
end
