%ACENET class definition
%
%   Usage:
%      cluster=acenet();
%      cluster=acenet('np',3);
%      cluster=acenet('np',3,'login','username');

classdef acenet
    properties (SetAccess=public) 
		 % {{{
		 name='glacdyn.ace-net.ca'
		 %name='placentia.ace-net.ca'
		 %name='brasdor.ace-net.ca'
		 login='klemorza';
		 np=10;
		 port=0;
		 queue='shortq';
		 time=10;
		 % codepath='/usr/local/issm-r11321/bin'; % this one is for issm on acenet global
		 codepath='/home/klemorza/issm/bin'; % this one is for issm on my acenet directory
		 executionpath='/home/klemorza/issm/execution';
		 %}}}
	 end
	 methods
		 function cluster=acenet(varargin) % {{{
			 %use provided options to change fields
			 options=pairoptions(varargin{:});

			 %initialize cluster using user settings if provided
			 if (exist([cluster.name '_settings'])==2), eval([cluster.name '_settings']); end

			 %OK get other fields
			 cluster=AssignObjectFields(pairoptions(varargin{:}),cluster);
		 end
		 %}}}
		 function disp(cluster) % {{{
			 %  display the object
			 disp(sprintf('class ''%s'' object ''%s'' = ',class(cluster),inputname(1)));
			 disp(sprintf('    name: %s',cluster.name));
			 disp(sprintf('    login: %s',cluster.login));
			 disp(sprintf('    np: %i',cluster.np));
			 disp(sprintf('    port: %i',cluster.port));
			 disp(sprintf('    queue: %s',cluster.queue));
			 disp(sprintf('    time: %i',cluster.time));
			 disp(sprintf('    codepath: %s',cluster.codepath));
			 disp(sprintf('    executionpath: %s',cluster.executionpath));
		 end
		 %}}}
		 function checkconsistency(cluster,md,solution,analyses) % {{{

			 available_queues={'debug','shortq','longq'};
			 queue_requirements_time=[60*1 60*3 60*17];
			 queue_requirements_np=[32 128 256];

			 QueueRequirements(available_queues,queue_requirements_time,queue_requirements_np,cluster.queue,cluster.np,cluster.time)
		 end
		 %}}}
		 function BuildQueueScript(cluster,modelname,solution,io_gather,isvalgrind,isgprof) % {{{

			 if(isvalgrind), disp('valgrind not supported by cluster, ignoring...'); end
			 if(isgprof),    disp('gprof not supported by cluster, ignoring...'); end

			 %write queuing script 
			 fid=fopen([modelname '.queue'],'w');
			 fprintf(fid,'#!/bin/bash\n');
			 fprintf(fid,'#$ -cwd\n');
          fprintf(fid,'#$ -N issm\n');
          fprintf(fid,'#$ -l h_rt=10:0:0\n');
          fprintf(fid,'#$ -pe ompi* %i\n',cluster.np);
          fprintf(fid,'#$ -j y\n');
          fprintf(fid,'module purge\n');
          fprintf(fid,'module load gcc openmpi/gcc\n');
          fprintf(fid,'module load issm\n');
          fprintf(fid,'\n');
          fprintf(fid,'mpiexec -np %i %s/issm.exe %s %s %s 2> %s.errlog >%s.outlog ',...
                   cluster.np,cluster.codepath,EnumToString(solution),cluster.executionpath,modelname,modelname,modelname);
			 fclose(fid);

		 end
		 %}}}
		 function LaunchQueueJob(cluster,md,options)% {{{
			  %retrieve parameters 
          modelname=md.miscellaneous.name;
          solution=md.private.solution;

			 %lauch command, to be executed via ssh
			 launchcommand=['cd ' cluster.executionpath ' && rm -rf ./' md.private.runtimename ' && mkdir ' md.private.runtimename ...
			                ' && cd ' md.private.runtimename ' && mv ../' md.private.runtimename '.tar.gz ./ && tar -zxf ' md.private.runtimename '.tar.gz  && qsub ' modelname '.queue '];

			if ~strcmpi(options.batch,'yes'),
				
				%compress the files into one zip.
				compressstring=['tar -zcf ' md.private.runtimename '.tar.gz ' md.miscellaneous.name '.bin ' md.miscellaneous.name '.queue '  md.miscellaneous.name '.petsc '];
				if md.qmu.isdakota,
					compressstring=[compressstring md.miscellaneous.name '.qmu.in'];
				end
				system(compressstring);
				
				disp('uploading input file and queueing script');
				issmscpout(md.cluster.name,md.cluster.executionpath,md.cluster.login,md.cluster.port,{[md.private.runtimename '.tar.gz']});
				
				disp('launching solution sequence on remote cluster');
				issmssh(md.cluster.name,md.cluster.login,md.cluster.port,launchcommand);

			else
				disp('batch mode requested: not launching job interactively');
				disp('launch solution sequence on remote cluster by hand');
			end

		 end
		 %}}}
		 function Download(cluster,dirname,filelist)% {{{

			 %copy files from cluster to current directory
			 directory=[cluster.executionpath '/' dirname '/'];
			 issmscpin(cluster.name,cluster.login,cluster.port,directory,filelist);

		 end %}}}
	end
end
