/*! \file TriaP1Input.h 
 *  \brief: header file for TriaP1Input object
 */


#ifndef _TRIAP1INPUT_H_
#define _TRIAP1INPUT_H_

/*Headers:*/
/*{{{1*/
#include "./Input.h"
#include "../Elements/TriaRef.h"
class GaussTria;
/*}}}*/

class TriaP1Input: public Input,public TriaRef{

	public:
		/*just hold 3 values for 3 vertices: */
		int    enum_type;
		double values[3];

		/*TriaP1Input constructors, destructors: {{{1*/
		TriaP1Input();
		TriaP1Input(int enum_type,double* values);
		~TriaP1Input();
		/*}}}*/
		/*Object virtual functions definitions:{{{1 */
		void  Echo();
		void  DeepEcho();
		int   Id(); 
		int   MyRank();
		int   ObjectEnum();
		Object* copy();
		/*}}}*/
		/*TriaP1Input management: {{{1*/
		int   InstanceEnum();
		Input* SpawnTriaInput(int* indices);
		Input* PointwiseDivide(Input* inputB){_error_("not implemented yet");};
		Input* PointwiseMin(Input* inputB);
		Input* PointwiseMax(Input* inputB);
		ElementResult* SpawnResult(int step, double time);
		void AddTimeValues(double* values,int step,double time){_error_("not supported yet");};
		void Configure(Parameters* parameters);
		/*}}}*/
		/*numerics: {{{1*/
		void GetInputValue(bool* pvalue){_error_("not implemented yet");}
		void GetInputValue(int* pvalue){_error_("not implemented yet");}
		void GetInputValue(double* pvalue){_error_("not implemented yet");}
		void GetInputValue(double* pvalue,GaussTria* gauss);
		void GetInputValue(double* pvalue,GaussPenta* gauss){_error_("not implemented yet");};
		void GetInputValue(double* pvalue,GaussTria* gauss,double time){_error_("not implemented yet");};
		void GetInputValue(double* pvalue,GaussPenta* gauss,double time){_error_("not implemented yet");};
		void GetInputValue(double* pvalue,GaussTria* gauss ,int index){_error_("not implemented yet");};
		void GetInputValue(double* pvalue,GaussPenta* gauss,int index){_error_("not implemented yet");};
		void GetInputDerivativeValue(double* derivativevalues, double* xyz_list, GaussTria* gauss);
		void GetInputDerivativeValue(double* derivativevalues, double* xyz_list, GaussPenta* gauss){_error_("not implemented yet");};
		void GetInputAverage(double* pvalue);
		void GetVxStrainRate2d(double* epsilonvx,double* xyz_list, GaussTria* gauss);
		void GetVyStrainRate2d(double* epsilonvy,double* xyz_list, GaussTria* gauss);
		void GetVxStrainRate3d(double* epsilonvx,double* xyz_list, GaussPenta* gauss){_error_("not implemented yet");};
		void GetVyStrainRate3d(double* epsilonvy,double* xyz_list, GaussPenta* gauss){_error_("not implemented yet");};
		void GetVzStrainRate3d(double* epsilonvz,double* xyz_list, GaussPenta* gauss){_error_("not implemented yet");};
		void GetVxStrainRate3dPattyn(double* epsilonvx,double* xyz_list, GaussPenta* gauss){_error_("not implemented yet");};
		void GetVyStrainRate3dPattyn(double* epsilonvy,double* xyz_list, GaussPenta* gauss){_error_("not implemented yet");};
		void ChangeEnum(int newenumtype);

		void SquareMin(double* psquaremin, bool process_units,Parameters* parameters);
		void ConstrainMin(double minimum);
		void Scale(double scale_factor);
		void ArtificialNoise(double min,double max);
		void AXPY(Input* xinput,double scalar);
		void Constrain(double cm_min, double cm_max);
		double InfinityNorm(void);
		double Max(void);
		double MaxAbs(void);
		double Min(void);
		double MinAbs(void);
		void Extrude(void){_error_("not supported yet");};
		void VerticallyIntegrate(Input* thickness_input){_error_("not supported yet");};
		void GetVectorFromInputs(Vector* vector,int* doflist);
		void GetValuesPtr(double** pvalues,int* pnum_values);
		/*}}}*/

};
#endif  /* _TRIAP1INPUT_H */
