/*! \file Contour.c
 *  \sa Contour.h
 */

#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include <string.h>
#include "./objects.h"
#include "../include/include.h"
#include "../io/io.h"

/*Contour constructors and destructors:*/
/*FUNCTION Contour::Contour() default constructor {{{1*/
Contour::Contour(){
	this->id=0;
	this->nods=0;
	this->x=NULL;
	this->y=NULL;
	this->closed=false;
}
/*}}}*/
/*FUNCTION Contour::Contour(int pid, int nods, IssmDouble* x, IssmDouble* y,bool closed) {{{1*/
Contour::Contour(int pid,int pnods, IssmDouble* px, IssmDouble* py,bool pclosed){
	
	this->id=pid;
	this->nods=pnods;
	this->closed=pclosed;
	if(nods){
		this->x=xNew<IssmDouble>(nods);
		xMemCpy<IssmDouble>(this->x,px,nods);
		this->y=xNew<IssmDouble>(nods);
		xMemCpy<IssmDouble>(this->y,py,nods);
	}
}
/*}}}*/
/*FUNCTION Contour::Contour() default constructor {{{1*/
Contour::~Contour(){
	xDelete<IssmDouble>(this->x);
	xDelete<IssmDouble>(this->y);
}
/*}}}*/


/*Object virtual function resolutoin: */
/*FUNCTION Contour::Echo(){{{1*/
void Contour::Echo(void){

	int i;

	printf("Contour: %i:\n",id);
	printf("   nods: %i\n",nods);
	printf("   closed: %s\n",closed?"true":"false");
	if(nods){
		printf("   x,y:\n");
		for(i=0;i<nods;i++){
			printf("%i: %g|%g\n",i,x[i],y[i]);
		}
	}
}
/*}}}*/
/*FUNCTION Contour::DeepEcho(){{{1*/
void Contour::DeepEcho(void){
	this->Echo();
}
/*}}}*/
/*FUNCTION Contour::Id(){{{1*/
int Contour::Id(void){
	return id;
}
/*}}}*/
/*FUNCTION Contour::MyRank{{{1*/
int    Contour::MyRank(void){ 
	extern int my_rank;

	return my_rank; 
}
/*}}}*/
/*FUNCTION Contour::ObjectEnum{{{1*/
int Contour::ObjectEnum(void){

	return ContourEnum;

}
/*}}}*/
/*FUNCTION Contour::copy {{{1*/
Object* Contour::copy() {

	return new Contour(*this); 

}
/*}}}*/
