/* \file xNewDelete.h
 * \brief: header file for templated new/delete checking for non-null pointers
 */

#ifndef _XNEWDELETE_H_
#define _XNEWDELETE_H_

#include <cassert>

template <class T> 
T* xNew(unsigned int size) {
  T* aT_p=new T[size];
  assert(aT_p);
  return aT_p;
};

template <class T> 
T* xNewInit(unsigned int size, const T initVal) {
  T* aT_p=new T[size];
  assert(aT_p);
  for (int i=0; i<size;++i) 
    aT_p[i]=initVal;
  return aT_p;
};

template <class T>
void xDelete(T*& aT_p) { 
  if (aT_p) 
    delete []aT_p;
  aT_p=0;
};

#endif

