#GENERIC cluster class definition
#
#   Usage:
#      cluster=generic('name','astrid',);
#      cluster=generic('name','astrid','np',3);
#      cluster=generic('name',oshostname(),'np',3,'login','username');


class generic:
	#properties
	def __init__(self):
		# {{{ Properties
		self.name=''
		self.login=''
		self.np=1
		self.port=0
		self.interactive=1
		self.codepath=issmdir() + '/bin'
		self.executionpath=issmdir() + '/execution'
		self.valgrind=issmdir() + '/externalpackages/valgrind/install/bin/valgrind'
		self.valgrindlib=issmdir() + '/externalpackages/valgrind/install/lib/libmpidebug.so'
		self.valgrindsup=issmdir() + '/externalpackages/valgrind/issm.supp'
		#}}}
	def __repr__(obj):
		# {{{ Display
		
		string="class 'generic' object:"
		string="%s\n\n%s"%(string,"%s%s"%('    name: ',obj.name))
		string="%s\n%s"%(string,"%s%i"%('    np: ',obj.np))
		string="%s\n%s"%(string,"%s%i"%('    port: ',obj.port))
		string="%s\n%s"%(string,"%s%s"%('    codepath: ',obj.codepath))
		string="%s\n%s"%(string,"%s%s"%('    executionpath: ',obj.executionpath))
		string="%s\n%s"%(string,"%s%s"%('    valgrind: ',obj.valgrind))
		string="%s\n%s"%(string,"%s%s"%('    valgrindlib: ',obj.valgrindlib))
		string="%s\n%s"%(string,"%s%s"%('    valgrindsup: ',obj.valgrindsup))
		return string
		#}}}
