/*!\file Segment.c
 * \brief: implementation of the Segment object
 */

/*Include files: {{{1*/
#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include <stdio.h>
#include <string.h>
#include "./objects.h"
#include "../Container/Container.h"
#include "../EnumDefinitions/EnumDefinitions.h"
#include "../shared/shared.h"
#include "../include/include.h"
/*}}}*/

/*Segment constructors and destructors:*/
/*FUNCTION Segment::Segment() default constructor {{{1*/
Segment::Segment(){
	this->eid=UNDEF;
	this->x1=UNDEF;
	this->y1=UNDEF;
	this->x2=UNDEF;
	this->y2=UNDEF;
}
/*}}}*/
/*FUNCTION Segment::Segment(int eid, IssmDouble x1,IssmDouble y1,IssmDouble x2, IssmDouble y2){{{1*/
Segment::Segment(int segment_eid, IssmDouble segment_x1,IssmDouble segment_y1,IssmDouble segment_x2, IssmDouble segment_y2){

	this->eid=segment_eid;
	this->x1=segment_x1;
	this->y1=segment_y1;
	this->x2=segment_x2;
	this->y2=segment_y2;

}
/*}}}*/
/*FUNCTION Segment::~Segment(){{{1*/
Segment::~Segment(){
}
/*}}}*/

/*Object virtual functions definitions:*/
/*FUNCTION Segment::Echo{{{1*/
void Segment::Echo(void){

	printf("Segment:\n");
	printf("   eid: %i\n",eid);
	printf("   node 1: %g|%g\n",this->x1,this->y1);
	printf("   node 2: %g|%g\n",this->x2,this->y2);

}
/*}}}*/
/*FUNCTION Segment::DeepEcho{{{1*/
void Segment::DeepEcho(void){
	this->Echo();
}
/*}}}*/
/*FUNCTION Segment::Id{{{1*/
int    Segment::Id(void){ return eid; }
/*}}}*/
/*FUNCTION Segment::MyRank{{{1*/
int    Segment::MyRank(void){ 
	extern int my_rank;

	return my_rank; 
}
/*}}}*/
/*FUNCTION Segment::ObjectEnum{{{1*/
int Segment::ObjectEnum(void){

	return SegmentEnum;

}
/*}}}*/
/*FUNCTION Segment::copy {{{1*/
Object* Segment::copy() {
	return new Segment(this->eid,this->x1,this->y1,this->x2,this->y2);

}

/*}}}*/
