#!/bin/bash

#1: install numpy
#2 install scipy
#3 erase
install=2


export CC="gcc -fPIC"
export CXX="g++ -fPIC"
export F77="gfortran -fPIC"
export FC="gfortran -fPIC"
export FFLAGS=-ff2c


if [[ $install == "1" ]];then 

	#download numpy first

	export GIT_SSL_NO_VERIFY=true 
	git clone https://github.com/numpy/numpy.git

	#install numpy
	cd numpy
	python setup.py build
	python setup.py install

	
elif [[ $install == "2" ]];then 
	
	#download scipy
	export GIT_SSL_NO_VERIFY=true 
	git clone https://github.com/scipy/scipy.git

	#install scipy
	cd scipy
	export  BLAS_SRC=$ISSM_DIR/externalpackages/blas/install/lib
	export  BLAS=$ISSM_DIR/externalpackages/blas/install/lib
	export  LAPACK_SRC=$ISSM_DIR/externalpackages/lapack/install/lib
	export  LAPACK=$ISSM_DIR/externalpackages/lapack/install/lib

	python setup.py build
	python setup.py install

elif [[ $install == "3" ]];then 
	rm -rf numpy scipy
else 
	echo "Choice not covered"
fi
