#!/bin/bash

#Some cleanup
rm -rf install petsc-3.2-p3 src
mkdir install src

#Download from ISSM server
$ISSM_DIR/scripts/DownloadExternalPackage.py 'http://issm.jpl.nasa.gov/files/externalpackages/petsc-3.2-p3.tar.gz' 'petsc-3.2-p3.tar.gz'

#Untar and move petsc to install directory
tar -zxvf  petsc-3.2-p3.tar.gz
mv petsc-3.2-p3/* src/
rm -rf petsc-3.2-p3

#configure
cd src
./config/configure.py \
	--prefix="$ISSM_DIR/externalpackages/petsc/install" \
	--PETSC_DIR="$ISSM_DIR/externalpackages/petsc/src" \
	--PETSC_ARCH="$ISSM_ARCH" \
	--with-batch=1 \
	--with-debugging=0 \
	--with-shared-libraries=0 \
	--known-mpi-shared-libraries=1 \
	--with-mpi-dir=/usr/local/intel/mpi/3.2.2.006/lib64 \
	--with-blas-lapack-dir=/usr/local/intel/mkl/10.1.2.024/lib/64/ \
	--download-mumps=yes \
	--download-scalapack=yes \
	--download-blacs=yes \
	--download-plapack=yes \
	--download-parmetis=yes \
	--with-pic=1

echo "== Follow PETSc's instructions"
