#!/bin/bash

#some issues on macosx64 with ISSM's autoconf. you might want to run native to mac on this.

#Some cleanup
rm -rf install ADOL-C-2.2.0 src

#Download from ISSM server
$ISSM_DIR/scripts/DownloadExternalPackage.py 'http://issm.jpl.nasa.gov/files/externalpackages/ADOL-C-2.2.0.tar.gz' 'ADOL-C-2.2.0.tar.gz'

#Create install directories
mkdir install src

#Untar 
tar -zxvf  ADOL-C-2.2.0.tar.gz

#Move ADOL-C into install directory
mv ADOL-C-2.2.0/* src
rm -rf ADOL-C-2.2.0

#Compile ADOL-C
cd src 

./configure \
	--prefix=$ISSM_DIR/externalpackages/adolc/install \
	--enable-sparse \
	--enable-docexa \
	--enable-addexa \
	--disable-shave

if [ -z $1 ]; then
	make
else
	make -j $1
fi
make install
