/*\file Kriging.c
 *\brief: best linear predictor
 */
#include "./Kriging.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*Outputs*/
	double  *x            = NULL;
	double  *y            = NULL;
	double  *observations = NULL;
	double  *x_interp     = NULL;
	double  *y_interp     = NULL;
	double  *predictions  = NULL;
	double  *error        = NULL;
	Options *options      = NULL;
	int      N_interp,M_interp,M,N,n_obs;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	if (nrhs<NRHS || nlhs>NLHS){
		KrigingUsage(); _error_("Kriging usage error");
	}

	/*Fetch inputs: */
	FetchData(&x,&n_obs,X);
	FetchData(&y,&N,Y);                       if(n_obs!=N) _error_("x and y should have the same size");
	FetchData(&observations,&N,OBSERVATIONS); if(n_obs!=N) _error_("x and observations should have the same size");
	FetchData(&x_interp,&M_interp,&N_interp,XINTERP);
	FetchData(&y_interp,&M,&N,YINTERP);       if(N!=N_interp || M!=M_interp) _error_("x_interp and y_interp should have the same size");
	FetchData(&options,NRHS,nrhs,prhs);

	/*Call x layer*/
	Krigingx(&predictions,&error,x,y,observations,n_obs,x_interp,y_interp,M_interp*N_interp,options);

	/*Generate output Matlab Structures*/
	if(nlhs>=1) WriteData(PREDICTIONS,predictions,M_interp,N_interp);
	if(nlhs==2) WriteData(ERROR,error,M_interp,N_interp);

	/*Free ressources: */
	xfree((void**)&x);
	xfree((void**)&y);
	xfree((void**)&observations);
	xfree((void**)&x_interp);
	xfree((void**)&y_interp);
	xfree((void**)&predictions);
	xfree((void**)&error);

	/*end module: */
	MODULEEND();
}

void KrigingUsage(void){
	_printf_(true,"\n");
	_printf_(true,"   usage: predictions=%s(x,y,observations,x_interp,y_interp,'options');\n",__FUNCT__);
	_printf_(true,"   available options:\n");
	_printf_(true,"      -'model': Available variogram models 'gaussian' (default),'spherical','power','exponential'\n");
	_printf_(true,"         -'nugget': nugget effect (default 0.2)\n");
	_printf_(true,"         -'range':  for gaussian, spherical and exponential models (default sqrt(3))\n");
	_printf_(true,"         -'sill':   for gaussian, spherical and exponential models (default 1)\n");
	_printf_(true,"         -'slope':  for power model (default 1)\n");
	_printf_(true,"         -'power':  for power model (default 1)\n");
	_printf_(true,"      -'searchradius': search radius for each prediction (default is observations span)\n");
	_printf_(true,"      -'boxlength':    minimum length of quadtree boxes (useful to decrease the number of observations)\n");
	_printf_(true,"      -'maxdata':      minimum number of observations for a prediction (default is 50)\n");
	_printf_(true,"      -'mindata':      maximum number of observations for a prediction (default is 1)\n");
	_printf_(true,"      -'maxtrimming':  maximum trimming value (default is -1.e+21)\n");
	_printf_(true,"      -'mintrimming':  minimum trimming value (default is +1.e+21)\n");
	_printf_(true,"      -'minspacing':   minimum distance between observation (default is 0.01)\n");
	_printf_(true,"\n");
}
